/*******************************************************************************
 * Copyright (c) 2005 -- 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.sybase.asa;

import java.util.Properties;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.enablement.sybase.asa.ui.JDBCASAProfileTabs;


/**
 * Property page for ASA/ASE profiles
 * @author brianf
 */
public class JDBCASAProfilePropertyPage extends ProfileDetailsPropertyPage {

	// UI
	private JDBCASAProfileTabs mASATabs = null;
	
	// tab flags
	protected boolean mShowFilterTab = false;
	protected boolean mShowOptionalTab = true;

	// listener
	private ChangeListener tabsListener = null;
	
	/**
     * Constructor for JDBCProfilePropetyPage.
     */
    public JDBCASAProfilePropertyPage() {
        super();
        noDefaultAndApplyButton();
    }

    /**
     * @see PreferencePage#createContents(Composite)
     */
    protected void createCustomContents(Composite parent) {
		Composite content = new Composite(parent,SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		content.setLayout(layout);
		
		this.mASATabs = createTabs();
		this.mASATabs.setShowOptionalTab(this.mShowOptionalTab);
		this.mASATabs.setShowFilterTab(this.mShowFilterTab);
		this.mASATabs.createControl(content);
        
        initControls();

        tabsListener = new ChangeListener() {

			public void stateChanged(ChangeEvent arg0) {
				isValid();
			}
		};
		this.mASATabs.addChangeListener(tabsListener);
    }

	protected JDBCASAProfileTabs createTabs() {
		JDBCASAProfileTabs tabs = new JDBCASAProfileTabs();
		tabs.setIsPropertyPage(true);
		return tabs;
	}

    protected Properties collectProperties() {
    	return this.mASATabs.getProperties(); 
    }

    private void initControls() {
        setErrorMessage(null);
        IConnectionProfile profile = getConnectionProfile();
        String providerId = profile.getProviderId();
        this.mASATabs.setProviderID(providerId);
		this.mASATabs.setConnectionProfile(profile);
        isValid();
    }

	public String getDriverClass() {
		return this.mASATabs.getNamedPropertyFromDriverInstance("driverClass"); //$NON-NLS-1$
	}

	public String getDriverURL() {
		return this.mASATabs.getNamedPropertyFromDriverInstance("url"); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferencePage#isValid()
	 */
	public boolean isValid() {
		super.setErrorMessage( null );
		boolean isValid = this.mASATabs.isValid();
		if ( !isValid ) { //this.mProfileTabs.getErrorMessage() != null) {
			super.setErrorMessage( this.mASATabs.getErrorMessage());
			return false;
		}
		return super.isValid();
	}

	public void dispose() {
		this.mASATabs.removeChangeListener(this.tabsListener);
		super.dispose();
	}

    /**
	 * @return
	 */
	public boolean getShowFilterTab() {
		return this.mShowFilterTab;
	}
	/**
	 * @param flag
	 */
	public void setShowFilterTab( boolean flag ) {
		this.mShowFilterTab = flag;
	}
	/**
	 * @return
	 */
	public boolean getShowOptionalTab() {
		return this.mShowOptionalTab;
	}
	/**
	 * @param flag
	 */
	public void setShowOptionalTab( boolean flag ) {
		this.mShowOptionalTab = flag;
	}

	
}