/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: rcernich - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.sybase.asa;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.generic.JDBCConnection;

/**
 * This class is used to represent Derby embedded connections. There are a
 * couple of particulars to Derby embedded connections which require special
 * treatement.
 * 
 * One, Derby only supports a single connection per JVM when operating as an
 * embedded DB. This class ensures that only one instance of an embedded DB
 * connection exists at any given time.
 * 
 * Two, java.sql.Connection.close() is not supported by the Derby embedded JDBC
 * driver. Embedded connections must be closed using the following:
 * java.sql.Driver.getConnection("&lt;url&gt;;shutdown=true").
 * 
 * @author rcernich
 * 
 * Created on Jan 30, 2006
 */
public class JDBCASAJDBCConnection extends JDBCConnection {

	public JDBCASAJDBCConnection(IConnectionProfile profile,
										Class factoryClass) {
		super(profile, factoryClass);
	}
}
