/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTerm;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;

public class ATreeNode {
    public static final int ELEMENT_TYPE = 1;
    public static final int ATTRIBUTE_TYPE = 2;
    public static final int OTHER_TYPE = 0;
    private Object value;
    private ArrayList children = new ArrayList();
    private ATreeNode parent;
    private int type;
    private String dataType;
    private static HashMap xmlTypeToDataType = new HashMap();
    private XSElementDecl element;
    private XSAttributeDeclaration attr;

    static {
        try {
            xmlTypeToDataType.put("string", DataTypes.getTypeString(12));
            xmlTypeToDataType.put("byte", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("decimal", DataTypes.getTypeString(2));
            xmlTypeToDataType.put("double", DataTypes.getTypeString(8));
            xmlTypeToDataType.put("float", DataTypes.getTypeString(8));
            xmlTypeToDataType.put("int", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("integer", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("negativeInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("nonNegativeInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("nonPositiveInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("positiveInteger", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("short", DataTypes.getTypeString(4));
            xmlTypeToDataType.put("date", DataTypes.getTypeString(91));
            xmlTypeToDataType.put("dateTime", DataTypes.getTypeString(93));
            xmlTypeToDataType.put("time", DataTypes.getTypeString(92));
            xmlTypeToDataType.put("boolean", DataTypes.getTypeString(16));
        }
        catch (OdaException odaException) {
            // empty catch block
        }
    }

    private static String getDataType(String type) throws OdaException {
        Object result = xmlTypeToDataType.get(type);
        if (result == null) {
            return type;
        }
        return result.toString();
    }

    protected ATreeNode() {
    }

    public ATreeNode(XSElementDecl element) throws OdaException {
        this();
        this.element = element;
        this.value = element.getName();
        this.type = 1;
        this.dataType = element.getTypeDefinition().getName() != null ? ATreeNode.getDataType(element.getTypeDefinition().getName()) : ATreeNode.getDataType(element.getName());
    }

    private ATreeNode(XSAttributeDeclaration attrDeclaration) throws OdaException {
        this();
        this.attr = attrDeclaration;
        this.value = this.attr.getName();
        this.type = 2;
        this.dataType = ATreeNode.getDataType(attrDeclaration.getTypeDefinition().getName());
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getChildren() throws OdaException {
        if (this.children.size() != 0) {
            return this.children.toArray();
        }
        ArrayList result = new ArrayList();
        if (this.attr != null) {
            return result.toArray();
        }
        if (this.element != null && this.element.getTypeDefinition() instanceof XSComplexTypeDecl) {
            XSModelGroupImpl group = null;
            if (((XSComplexTypeDecl)this.element.getTypeDefinition()).getParticle() != null) {
                group = (XSModelGroupImpl)((XSComplexTypeDecl)this.element.getTypeDefinition()).getParticle().getTerm();
                this.populateModelGroup(result, group);
            }
            if (((XSComplexTypeDecl)this.element.getTypeDefinition()).getAttrGrp() != null) {
                XSAttributeGroupDecl gp1 = ((XSComplexTypeDecl)this.element.getTypeDefinition()).getAttrGrp();
                XSObjectList list = gp1.getAttributeUses();
                int i = 0;
                while (i < list.getLength()) {
                    XSAttributeUseImpl impl = (XSAttributeUseImpl)list.item(i);
                    ATreeNode node = new ATreeNode(impl.getAttrDeclaration());
                    this.addNodeToChild(result, node);
                    ++i;
                }
            }
        }
        return result.toArray();
    }

    private void populateModelGroup(List result, XSModelGroupImpl group) throws OdaException {
        int i = 0;
        while (i < group.getParticles().getLength()) {
            ATreeNode node = null;
            XSTerm o = ((XSParticleDecl)group.getParticles().item(i)).getTerm();
            if (o instanceof XSModelGroupImpl) {
                this.populateModelGroup(result, (XSModelGroupImpl)o);
            } else if (o instanceof XSElementDecl) {
                node = new ATreeNode((XSElementDecl)o);
                this.addNodeToChild(result, node);
            }
            ++i;
        }
    }

    private void addNodeToChild(List result, ATreeNode node) {
        int i = 0;
        while (i < result.size()) {
            if (((ATreeNode)result.get(i)).getValue().equals(node.getValue())) {
                return;
            }
            ++i;
        }
        result.add(node);
    }

    public ATreeNode getParent() {
        return this.parent;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void addChild(Object child) {
        this.children.add(child);
        ((ATreeNode)child).parent = this;
    }

    public void setParent(ATreeNode parent) {
        this.parent = parent;
        parent.addChild(this);
    }

    public String toString() {
        return this.value.toString();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDataType() throws OdaException {
        return this.dataType;
    }

    public void setDataType(String type) throws OdaException {
        this.dataType = ATreeNode.getDataType(type);
    }
}

