/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  Actuate Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.eclipse.datatools.connectivity.oda.OdaException;


/**
 * This class creates a restart-able input stream instance from either an ordinary input stream
 * or an input url.
 */
public class XMLDataInputStream extends InputStream
{
	//The url from the file or web address in which the InputStream come from.
	private IInputXMLDataSource inputDataSource;
	
	private String encoding;
	
	public String getEncoding( )
	{
		return encoding;
	}

	
	public void setEncoding( String encoding )
	{
		this.encoding = encoding;
	}

	/**
	 * construct an XMLDataInputStream instance using specified <code>url</code>.
	 * No encoding is specified so that it will be parsed automatically by the SaxParser.
	 * @param url
	 * @throws OdaException
	 */
	protected XMLDataInputStream( URL url ) throws OdaException
	{
		this.inputDataSource = new URLInputStream( url );
	}

	/**
	 * construct an XMLDataInputStream instance using specified <code>url</code> and <code>encoding</code>.
	 * @param url
	 * @param encoding
	 * @throws OdaException
	 */
	protected XMLDataInputStream( URL url, String encoding ) throws OdaException
	{
		this.inputDataSource = new URLInputStream( url );
		this.encoding = encoding;
	}
	/**
	 * 
	 * @param url
	 * @param encoding
	 * @throws OdaException
	 */
	protected XMLDataInputStream( IInputXMLDataSource url, String encoding ) throws OdaException
	{
		this.inputDataSource = url;
		this.encoding = encoding;
	}
	
	/**
	 * @deprecated
	 * Temporary - for BZ 142789. Keep this for backward compatibility with TPTP RC2
	 * Can be removed after 2.1RC3
	 * 
	 */
	public XMLDataInputStream( InputStream is ) throws OdaException
	{
		BufferedInputStream bis = new BufferedInputStream(is);
				
		try
		{
			File file = createFileWithUniqueName( );
			FileOutputStream fos = new FileOutputStream( file );
			int abyte;
			while( (abyte = bis.read())!= -1)
			{	
				fos.write(abyte);
			}
			fos.close();
			inputDataSource = new URLInputStream( file.toURL( ) );
		}
		catch ( IOException e )
		{
			throw new OdaException( e.getLocalizedMessage() );
		}
	}
	
	//The template file name which might be used to create a temp file for the InputStream
	private static final String TEMPFILENAME = "tempXMLData";
	
	/**
	 * 
	 * @return
	 * @throws IOException
	 */
	private File createFileWithUniqueName( ) throws IOException
	{
		File file = File.createTempFile(TEMPFILENAME,null);
		file.deleteOnExit( );
		return file;
	}
	
	/**
	 * Reset the InputStream to the very first position.
	 * 
	 * @throws IOException
	 */
	public void init( ) throws IOException
	{
		this.inputDataSource.init( );
	}

	/*
	 *  (non-Javadoc)
	 * @see java.io.InputStream#read()
	 */
	public int read( ) throws IOException
	{
		return this.inputDataSource.read( );
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.io.InputStream#close()
	 */
	public void close( ) throws IOException
	{
		this.inputDataSource.close( );
		super.close();
	}
}
