/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.InputStream;

/**
 * This class contains the content of data source, it should be either the file
 * path or the input stream.
 * 
 */
public class XMLCreatorContent
{
	private String encoding;
	private Object key;
	private long memorySize = 0;

	/**
	 * 
	 * @param obj
	 */
	public XMLCreatorContent( Object obj )
	{
		if ( obj == null )
			throw new NullPointerException( "Data source content is null" );

		if ( obj instanceof String || obj instanceof InputStream )
		{
			key = obj;
		}
		else
			throw new IllegalArgumentException( "The argument is not accepted" );
	}
	
	/**
	 * 
	 * @param encoding
	 */
	public void setEncoding( String encoding )
	{
		this.encoding = encoding;
	}
	
	/**
	 * 
	 * @return
	 */
	public String getEncoding( )
	{
		return this.encoding;
	}
	
	/**
	 * 
	 * @param size
	 */
	public void setMemorySize( long size )
	{
		this.memorySize = size;
	}
	
	/**
	 * 
	 * @return
	 */
	public long getMemorySize( )
	{
		if ( this.memorySize == 0 )
		{
			this.memorySize = 10;
		}
		return this.memorySize * 1024 * 1024;
	}
	
	/**
	 * 
	 * @return
	 */
	public Object getKey( )
	{
		return this.key;
	}
}
