/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * URL input stream data source.
 *
 */
class URLInputStream implements IInputXMLDataSource
{

	private URL url;
	private InputStream inputStream;
	
	URLInputStream( URL url )
	{
		this.url = url;
	}
	
	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#read()
	 */
	public int read( ) throws IOException
	{
		if ( this.inputStream != null )
			return this.inputStream.read( );
		return -1;
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#init()
	 */
	public void init( )
	{
		try
		{
			if ( this.inputStream == null )
				this.inputStream = new BufferedInputStream( url.openStream( ) );
			else
			{
				this.inputStream.close( );
				this.inputStream = new BufferedInputStream( url.openStream( ) );
			}
		}
		catch ( IOException e )
		{
		}
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputXMLDataSource#close()
	 */
	public void close( ) throws IOException
	{
		if ( inputStream != null )
			this.inputStream.close( );
	}

}
