/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  Actuate Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

/**
 * This is a utility class which is used to provide some functionality 
 * that are used in instance of ISaxParserConsumer
 */
public class SaxParserUtil
{
	public static final String TEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN$-";
	public static final String ROOTTEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN_ROOT$-";
	/**
	 * 
	 * @param path
	 *            the path which is stored as column path
	 * @param generatedPath
	 *            the path which is generated by sax parser
	 * @return
	 */
	public static boolean isSamePath( String path, String generatedPath )
	{
		return XPathParserUtil.match( generatedPath, path );
	}

	/**
	 * Dealing with ".." in a column path. Here the column path is the combination of root path
	 * and the give column path expression.
	 * 
	 * @param path
	 * @return
	 */
	public static String processParentAxis( String path )
	{
		String prefix = "";
		
		//First remove the leading "//" or "/"
		if ( path.startsWith( UtilConstants.XPATH_DOUBLE_SLASH ) )
		{
			path = path.replaceFirst( UtilConstants.XPATH_DOUBLE_SLASH, "" );
			prefix = UtilConstants.XPATH_DOUBLE_SLASH;
		}
		else if ( path.startsWith( UtilConstants.XPATH_SLASH ) )
		{
			path = path.replaceFirst( UtilConstants.XPATH_SLASH, "" );
			prefix = UtilConstants.XPATH_SLASH;
		}
		String[] temp = path.split( UtilConstants.XPATH_SLASH );
		for ( int i = 0; i < temp.length; i++ )
		{
			if ( temp[i].equals( ".." ) )
			{
				temp[i] = null;
				for ( int j = i - 1; j >= 0; j-- )
				{
					if ( temp[j] != null )
					{
						temp[j] = null;
						break;
					}
				}
			}
		}
		
		//Rebuild the path.
		path = prefix;
		for ( int i = 0; i < temp.length; i++ )
		{
			if ( temp[i] != null )
				path = i == 0 ? path + temp[i] : path + (temp[i].startsWith("[")?"":UtilConstants.XPATH_SLASH) + temp[i];
		}

		//Add comments
		if( path.startsWith( "///" ))
			path = path.replaceFirst( "\\Q/\\E", "" );
		return path;
	}
	
	/**
	 * Create a temp column name. The temp column are used for filtering.
	 * 
	 * @param index
	 * @return
	 */
	static String createTempColumnName( int index )
	{
		return TEMPCOLUMNNAMEPREFIX + index;
	}
	
	/**
	 * Create a temp column name for root filter. The temp column are used for filtering.
	 * 
	 * @param index
	 * @return
	 */
	static String createTableRootTempColumnNameForFilter( )
	{
		return ROOTTEMPCOLUMNNAMEPREFIX;
	}
	/**
	 * Return if the given column name stands for a temp column.
	 * 
	 * @param name
	 * @return
	 */
	static boolean isTempColumn( String name )
	{
		if( name == null )
			return false;
		else
			return name.startsWith( TEMPCOLUMNNAMEPREFIX ) || name.startsWith( ROOTTEMPCOLUMNNAMEPREFIX );
	}
}
