/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * input stream data source
 *
 */
class InputStreamST implements IInputXMLDataSource
{
	private InputStream inputStream;
	
	InputStreamST( InputStream stream )
	{
		this.inputStream = new BufferedInputStream( stream );
	}
	
	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#close()
	 */
	public void close( ) throws IOException
	{
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#init()
	 */
	public void init( )
	{
		//do nothing;
	}

	/*
	 * @see org.eclipse.datatools.enablement.oda.xml.util.IInputStream#read()
	 */
	public int read( ) throws IOException
	{
		return this.inputStream.read( );
	}

}
