/*******************************************************************************
 * Copyright (c) 2004, 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;

/**
 * This interface represents all kinds of xml data sources:it could be a
 * certain file,URL or the input stream from appContext etc.
 */
interface IInputXMLDataSource
{
	
	/**
	 * Initial the xml input data source
	 */
	void init( );

	/**
	 * Read the next byte of data source
	 * 
	 * @return
	 * @throws IOException
	 */
	int read( ) throws IOException;
	
	/**
	 * Close the data source when necessary
	 * 
	 * @throws IOException
	 */
	void close( ) throws IOException;
}
