/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class DbUnitPluginImages {
    public static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap fgAvoidSWTErrorMap = null;
    private static final String T_WIZBAN = "wizban";
    public static final ImageDescriptor DESC_WIZBAN_ADD_LIBRARY = DbUnitPluginImages.createUnManaged("wizban", "addlibrary_wiz.png");

    public static Image get(String key) {
        return DbUnitPluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getDescriptor(String key) {
        if (fgImageRegistry == null) {
            return (ImageDescriptor)fgAvoidSWTErrorMap.get(key);
        }
        return DbUnitPluginImages.getImageRegistry().getDescriptor(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        DbUnitPluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        DbUnitPluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = DbUnitPluginImages.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = DbUnitPluginImages.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return DbUnitPluginImages.createImageDescriptor(Activator.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createUnManaged(String prefix, String name) {
        return DbUnitPluginImages.create(prefix, name, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

