/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards.DbUnitWizard;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards.NewDbUnitTestCaseWizardPage1;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards.NewDbUnitTestCaseWizardPage2;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;

import org.eclipse.jdt.core.IType;

/**
 * A wizard for creating test cases.
 */
public class NewTestCaseCreationWizard extends DbUnitWizard {

	private NewDbUnitTestCaseWizardPage1 fPage1;
	private NewDbUnitTestCaseWizardPage2 fPage2;

	/**
	 * 
	 */
	public NewTestCaseCreationWizard() {
		super();
		setWindowTitle(DbUnitMessages.Wizard_title_new_testcase); 
		initDialogSettings();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards.DbUnitWizard#initializeDefaultPageImageDescriptor()
	 */
	protected void initializeDefaultPageImageDescriptor() {
		setDefaultPageImageDescriptor(Activator.getImageDescriptor("wizban/newtest_wiz.png")); //$NON-NLS-1$
	}

	/*
	 * @see Wizard#createPages
	 */	
	public void addPages() {
		super.addPages();
		fPage2= new NewDbUnitTestCaseWizardPage2();
		fPage1= new NewDbUnitTestCaseWizardPage1(fPage2);
		fPage1.setTitle(DbUnitMessages.NewTestCaseCreationWizard_WizardTitle);
		fPage1.setDescription(DbUnitMessages.NewTestCaseCreationWizard_WizardDescription);
		addPage(fPage1);
		fPage1.init(getSelection());
	}	
	
	/*
	 * @see Wizard#performFinish
	 */		
	public boolean performFinish() {
		if (finishPage(fPage1.getRunnable())) {
			IType newClass= fPage1.getCreatedType();
		
			IResource resource= newClass.getCompilationUnit().getResource();
			if (resource != null) {
				selectAndReveal(resource);
				openResource(resource);
			}
			return true;
		}
		return false;		
	}
}
