/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.IDBConnectionProfileConstants;
import org.eclipse.datatools.connectivity.db.generic.IDBDriverDefinitionConstants;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.enablement.jdt.classpath.internal.DriverClasspathContainer;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.dialogs.ResourceChooserDialog;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.widgets.IDataSelectionValidator;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.BuildPathSupport;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.DbUnitHomeInitializer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.ConnectionProfileGroup;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStatus;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStubUtility;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.LayoutUtil;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.Messages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStubUtility.GenStubSettings;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

/**
 * @author brianf
 *
 */
public class NewDbUnitTestCaseWizardPage1 extends NewTestCaseWizardPageOne {

	public final static String DEFAULT_DBUNIT_SUPERCLASS = "org.dbunit.DBTestCase"; //$NON-NLS-1$
	public final static String PROFILE_CHANGED = "profileChanged"; //$NON-NLS-1$

	private static final String BUILD_PATH_PAGE_ID= "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage"; //$NON-NLS-1$
	private static final Object BUILD_PATH_KEY_ADD_ENTRY= "add_classpath_entry"; //$NON-NLS-1$
	private static final Object BUILD_PATH_BLOCK= "block_until_buildpath_applied"; //$NON-NLS-1$

	private final static int IDX_GETSETUPOPERATION = 0;
	private final static int IDX_GETTEARDOWNOPERATION= 1;

	private Link fLink;
	private Link fDriverLink;
	private Label fImage;
	private Label fDriverImage;
	private MethodStubsSelectionButtonGroup fMethodStubsButtons;
	private ConnectionProfileGroup fProfileGroup;
	private IConnectionProfile fSelectedProfile = null;
	private Text fInitialDataSetText;
	private IStatus fProfileUnderTestStatus; // status
	
	/**
	 * @param page2
	 */
	public NewDbUnitTestCaseWizardPage1(NewTestCaseWizardPageTwo page2) {
		super(page2);

		String[] buttonNames= new String[] {
				/* IDX_GETSETUPOPERATION */ DbUnitMessages.NewTestCaseWizardPageOne_methodStub_getSetUpOperation,
				/* IDX_GETTEARDOWNOPERATION */ DbUnitMessages.NewTestCaseWizardPageOne_methodStub_getTearDownOperation
		};
		
		fMethodStubsButtons= new MethodStubsSelectionButtonGroup(SWT.CHECK, buttonNames, 2);
		fMethodStubsButtons.setLabelText(DbUnitMessages.NewTestCaseWizardPageOne_method_Stub_label); 

	}

	protected IStatus[] getStatusList() {
		ArrayList list = new ArrayList();
		list.addAll(Arrays.asList(super.getStatusList()));
		list.add(fProfileUnderTestStatus);
		return (IStatus[]) list.toArray(new IStatus[list.size()]);
	}

	protected IStatus profileUnderTestChanged() {
		DbUnitStatus status= new DbUnitStatus();

		String datasetName = this.fInitialDataSetText.getText();
		if (datasetName == null || datasetName.length() == 0) {
			File testFile = new File(datasetName);
			if (!testFile.canRead())
				status.setError(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Error_Must_Select_Valid_File); 
		}
		
		return status;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#createClassUnderTestControls(org.eclipse.swt.widgets.Composite, int)
	 */
	protected void createClassUnderTestControls(Composite composite, int nColumns) {
		Label profileToTestAgainstLabel = new Label(composite, SWT.LEFT | SWT.WRAP);
		profileToTestAgainstLabel.setFont(composite.getFont());
		profileToTestAgainstLabel.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Profile_Under_Test_Label); 
		profileToTestAgainstLabel.setLayoutData(new GridData());

		fProfileGroup = new ConnectionProfileGroup(composite, false, true, false, nColumns);
		fProfileGroup.setCategory(ConnectionProfileGroup.JDBC_CATEGORY);
		fProfileGroup.fillConnectionProfiles();
		
		Label noteAboutProperties = new Label(composite, SWT.LEFT | SWT.WRAP);
		noteAboutProperties.setFont(composite.getFont());
		noteAboutProperties.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Profile_Note);
		GridData napGridData = new GridData();
		napGridData.horizontalSpan = nColumns;
		noteAboutProperties.setLayoutData(napGridData);
		
		fProfileGroup.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				String profileName = NewDbUnitTestCaseWizardPage1.this.fProfileGroup.getSelectedProfile();
				if (ProfileManager.getInstance().getProfileByName(profileName) != null) { 
					NewDbUnitTestCaseWizardPage1.this.fSelectedProfile = 
						ProfileManager.getInstance().getProfileByName(profileName);
					NewDbUnitTestCaseWizardPage1.this.updateBuildPathMessage2();
					NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(PROFILE_CHANGED);
//					NewDbUnitTestCaseWizardPage1.this.fProfileUnderTestStatus= profileUnderTestChanged();
				}
			}
		});

		Label spacerLabel = new Label(composite, SWT.FILL);
		spacerLabel.setFont(composite.getFont());
		spacerLabel.setText("");  //$NON-NLS-1$
		GridData spLabelGD = new GridData();
		spLabelGD.horizontalSpan = nColumns;
		spacerLabel.setLayoutData(spLabelGD);
		
		Label initialDataSetLabel = new Label(composite, SWT.LEFT | SWT.WRAP);
		initialDataSetLabel.setFont(composite.getFont());
		initialDataSetLabel.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Initial_Dataset_Text_Label); 
		initialDataSetLabel.setLayoutData(new GridData());
		
		fInitialDataSetText = new Text(composite, SWT.BORDER);
		fInitialDataSetText.setFont(composite.getFont());
		fInitialDataSetText.setText("dataset.xml");  //$NON-NLS-1$
		GridData idsGridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		idsGridData.horizontalSpan = 2;
		fInitialDataSetText.setLayoutData(idsGridData);
		fInitialDataSetText.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(PROFILE_CHANGED);
			}
		});
		
		Button browseFile = new Button(composite, SWT.PUSH);
		browseFile.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Browse_Button_Label);
		browseFile.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL ));
		browseFile.addSelectionListener(new SelectionListener(){

			public void widgetDefaultSelected(SelectionEvent e) {
				String newLocation = 
					handleLocationEditButtonPressed(NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.getText());
				
				if (newLocation != null && !newLocation.equals(NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.getText())) {
					NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.setText(newLocation);
				}
				NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(PROFILE_CHANGED);
//				NewDbUnitTestCaseWizardPage1.this.fProfileUnderTestStatus= profileUnderTestChanged();
			}

			public void widgetSelected(SelectionEvent e) {
				widgetDefaultSelected(e);
			}
		});
		
		profileUnderTestChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#init(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IStructuredSelection selection) {
		super.init(selection);
		setSuperClass(DEFAULT_DBUNIT_SUPERCLASS, true);
		setAddComments(true, true);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#createBuildPathConfigureControls(org.eclipse.swt.widgets.Composite, int)
	 */
	protected void createBuildPathConfigureControls(Composite composite, int nColumns) {
		super.createBuildPathConfigureControls(composite, nColumns);
		
		Composite inner= new Composite(composite, SWT.NONE);
		inner.setLayoutData(new GridData(GridData.FILL, GridData.FILL, false, false, nColumns, 1));
		GridLayout layout= new GridLayout(2, false);
		layout.marginWidth= 0;
		layout.marginHeight= 0;
		inner.setLayout(layout);
		
		fImage= new Label(inner, SWT.NONE);
		fImage.setImage(JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_WARNING));
		fImage.setLayoutData(new GridData(GridData.BEGINNING, GridData.BEGINNING, false, false, 1, 1));

		fLink= new Link(inner, SWT.WRAP);
		fLink.setText("\n\n"); //$NON-NLS-1$
		fLink.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				performBuildpathConfiguration(e.text);
			}
		});
		GridData gd= new GridData(GridData.FILL, GridData.BEGINNING, true, false, 1, 1);
		gd.widthHint= convertWidthInCharsToPixels(60);
		fLink.setLayoutData(gd);
		updateBuildPathMessage();

		fDriverImage= new Label(inner, SWT.NONE);
		fDriverImage.setImage(JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_WARNING));
		fDriverImage.setLayoutData(new GridData(GridData.BEGINNING, GridData.BEGINNING, false, false, 1, 1));

		fDriverLink= new Link(inner, SWT.WRAP);
		fDriverLink.setText("\n\n"); //$NON-NLS-1$
		fDriverLink.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				performBuildpathConfiguration(e.text);
			}
		});
		gd= new GridData(GridData.FILL, GridData.BEGINNING, true, false, 1, 1);
		gd.widthHint= convertWidthInCharsToPixels(60);
		fDriverLink.setLayoutData(gd);
		updateBuildPathMessage2();
}

	/**
	 * @param data
	 */
	private void performBuildpathConfiguration(Object data) {
		IPackageFragmentRoot root= getPackageFragmentRoot();
		if (root == null) {
			return; // should not happen. Link shouldn't be visible
		}
		IJavaProject javaProject= root.getJavaProject();
		
		if ("ad2".equals(data)) { // add and configure DbUnit 2 //$NON-NLS-1$
			String id= BUILD_PATH_PAGE_ID;
			Map input= new HashMap();

			IClasspathEntry newEntry= BuildPathSupport.getDbUnit2VariableEntry();
			
			IPath path = JavaCore.getClasspathVariable(DbUnitHomeInitializer.DBUNIT_HOME);
			if (path == null || !path.toFile().exists()) {
				DbUnitHomeInitializer initializer = new DbUnitHomeInitializer();
				initializer.initialize(DbUnitHomeInitializer.DBUNIT_HOME);
				path = JavaCore.getClasspathVariable(DbUnitHomeInitializer.DBUNIT_HOME);
				newEntry= BuildPathSupport.getDbUnit2VariableEntry();
				if (path == null || !path.toFile().exists()) {
					MessageDialog.openError(this.getShell(), 
							DbUnitMessages.NewDbUnitTestCaseWizardPage1_ErrorInitializingHome_Title, 
							DbUnitMessages.NewDbUnitTestCaseWizardPage1_ErrorInitializingHome_message);
					return;
				}
			}

			IClasspathEntry updatedEntry = BuildPathSupport.updateNativeLibraryForClassPath(path.makeAbsolute().toOSString(), root, newEntry);
			input.put(BUILD_PATH_KEY_ADD_ENTRY, updatedEntry);
			input.put(BUILD_PATH_BLOCK, Boolean.TRUE);

			PreferencesUtil.createPropertyDialogOn(getShell(), javaProject, id, new String[] { id }, input).open();
		}
		else if ("adl".equals(data)) { // add and configure DbUnit 2 //$NON-NLS-1$
			String id= BUILD_PATH_PAGE_ID;
			Map input= new HashMap();
			if (fSelectedProfile != null) {
				String driverID = fSelectedProfile
					.getBaseProperties()
					.getProperty(
						ConnectionProfileConstants.PROP_DRIVER_DEFINITION_ID);
				
				DriverInstance di = 
					DriverManager.getInstance().getDriverInstanceByID(driverID);

				IClasspathContainer container = new DriverClasspathContainer(di.getName());
				
				try {
					JavaCore.setClasspathContainer(container.getPath(), new IJavaProject[] { javaProject }, new IClasspathContainer[] {container},  null);
				} catch (JavaModelException e) {
					e.printStackTrace();
				}

				input.put(BUILD_PATH_KEY_ADD_ENTRY, container.getClasspathEntries()[0]);
				input.put(BUILD_PATH_BLOCK, Boolean.TRUE);

				PreferencesUtil.createPropertyDialogOn(getShell(), javaProject, id, new String[] { id }, input).open();
			}
		}
		refreshProject();
		updateBuildPathMessage();
		updateBuildPathMessage2();
	}

	/**
	 * 
	 */
	private void updateBuildPathMessage() {
		if (fLink == null || fLink.isDisposed()) {
			return;
		}
		
		String message= null;
		IPackageFragmentRoot root= getPackageFragmentRoot();
		if (root != null) {
			try {
				IJavaProject project= root.getJavaProject();
				if (project.findType(DEFAULT_DBUNIT_SUPERCLASS) == null) {
					message= Messages.format(DbUnitMessages.NewTestCaseWizardPageOne_linkedtext_dbunit2_notonbuildpath, project.getElementName());
				}
			} catch (JavaModelException e) {
			}
		}
		fLink.setVisible(message != null);
		fImage.setVisible(message != null);
		
		if (message != null) {
			fLink.setText(message);
		}
	}

	/**
	 * 
	 */
	private void updateBuildPathMessage2() {
		if (fDriverLink == null || fDriverLink.isDisposed()) {
			return;
		}
		
		String message= null;
		IPackageFragmentRoot root= getPackageFragmentRoot();
		if (root != null) {
			try {
				IJavaProject project= root.getJavaProject();
				if (fSelectedProfile != null) {
					String driverID = fSelectedProfile
						.getBaseProperties()
						.getProperty(
							ConnectionProfileConstants.PROP_DRIVER_DEFINITION_ID);
					
					DriverInstance di = 
						DriverManager.getInstance().getDriverInstanceByID(driverID);
					String driverClass = di.getProperty(
							IDBConnectionProfileConstants.DRIVER_CLASS_PROP_ID);
					if (project.findType(driverClass) == null) {
						message= Messages.format(DbUnitMessages.NewTestCaseWizardPageOne_linkedtext_driver_library_notonbuildpath, project.getElementName());
					}
				}
			} catch (JavaModelException e) {
			}
		}
		fDriverLink.setVisible(message != null);
		fDriverImage.setVisible(message != null);
		
		if (message != null) {
			fDriverLink.setText(message);
		}
	}

	/**
	 * Creates the controls for the method stub selection buttons. Expects a <code>GridLayout</code> with 
	 * at least 3 columns.
	 * 
	 * @param composite the parent composite
	 * @param nColumns number of columns to span
	 */		
	protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
		LayoutUtil.setHorizontalSpan(fMethodStubsButtons.getLabelControl(composite), nColumns);
		LayoutUtil.createEmptySpace(composite, 1);
		LayoutUtil.setHorizontalSpan(fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);	
	}	

	/**
	 * @param type
	 * @param methodName
	 * @param isStatic
	 * @param annotationType
	 * @param imports
	 * @param returnClass
	 * @param callSuper
	 * @throws CoreException
	 */
	private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, ImportsManager imports, Class returnClass, boolean callSuper) throws CoreException {
		createSetupStubs(type, methodName, isStatic, annotationType, imports, returnClass, callSuper, null);
	}
	
	/**
	 * @param type
	 * @param methodName
	 * @param isStatic
	 * @param annotationType
	 * @param imports
	 * @param returnClass
	 * @param callSuper
	 * @param extraReturnClause
	 * @throws CoreException
	 */
	private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, ImportsManager imports, Class returnClass, boolean callSuper, String extraReturnClause) throws CoreException {
		String content= null;
		IMethod methodTemplate= findInHierarchy(type, methodName);
		String annotation= null;
		if (isJUnit4()) {
			annotation= '@' + imports.addImport(annotationType);
		}
		
		GenStubSettings settings= DbUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
		settings.createComments= isAddComments();
		
		if (methodTemplate != null) {
			settings.callSuper= callSuper;
			settings.methodOverwrites= true;
			if (extraReturnClause != null)
				content= DbUnitStubUtility.genStub(type.getCompilationUnit(), getTypeName(), methodTemplate, settings, annotation, imports, extraReturnClause);
			else
				content= DbUnitStubUtility.genStub(type.getCompilationUnit(), getTypeName(), methodTemplate, settings, annotation, imports);
		} else {
			final String delimiter= getLineDelimiter();
			StringBuffer buffer= new StringBuffer();
			if (settings.createComments) {
				String[] excSignature= { Signature.createTypeSignature("java.lang.Exception", true) }; //$NON-NLS-1$
				String comment= CodeGeneration.getMethodComment(type.getCompilationUnit(), type.getElementName(), methodName, new String[0], excSignature, Signature.SIG_VOID, null, delimiter);
				if (comment != null) {
					buffer.append(comment);
				}
			}
			if (annotation != null) {
				buffer.append(annotation).append(delimiter);
			}
			
			if (isJUnit4()) {
				buffer.append("public "); //$NON-NLS-1$
			} else {
				buffer.append("protected "); //$NON-NLS-1$
			}
			if (isStatic) {
				buffer.append("static "); //$NON-NLS-1$
			}
			if (returnClass != null) {
				
			}
			else {
				buffer.append("void "); //$NON-NLS-1$
			}
			buffer.append(methodName);
			buffer.append("() throws "); //$NON-NLS-1$
			buffer.append(imports.addImport("java.lang.Exception")); //$NON-NLS-1$
			buffer.append(" {}"); //$NON-NLS-1$
			buffer.append(delimiter);
			content= buffer.toString();
		}
		type.createMethod(content, null, false, null);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#createTypeMembers(org.eclipse.jdt.core.IType, org.eclipse.jdt.ui.wizards.NewTypeWizardPage.ImportsManager, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void createTypeMembers(IType type, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
		
		refreshProject();
		
		createConstructor(type, imports); 	
		createGetDataSet(type, imports);
		
		if (fMethodStubsButtons.isSelected(IDX_GETSETUPOPERATION)) {
			createGetSetupOperation(type, imports);
		}
		
		if (fMethodStubsButtons.isSelected(IDX_GETTEARDOWNOPERATION)) {
			createGetTeardownOperation(type, imports);
		}
		
		if (isJUnit4()) { 
			imports.addStaticImport("org.junit.Assert", "*", false); //$NON-NLS-1$ //$NON-NLS-2$
		}
		
	}
	
	/**
	 * @param type
	 * @param imports
	 * @throws CoreException
	 */
	private void createConstructor(IType type, ImportsManager imports) throws CoreException {
		ITypeHierarchy typeHierarchy= null;
		IType[] superTypes= null;
		String content = ""; //$NON-NLS-1$
		IMethod methodTemplate= null;
		if (type.exists()) {
			typeHierarchy= type.newSupertypeHierarchy(null);
			superTypes= typeHierarchy.getAllSuperclasses(type);
			for (int i= 0; i < superTypes.length; i++) {
				if (superTypes[i].exists()) {
					IMethod constrMethod= superTypes[i].getMethod(superTypes[i].getElementName(), new String[] {"Ljava.lang.String;"}); //$NON-NLS-1$
					if (constrMethod.exists() && constrMethod.isConstructor()) {
						methodTemplate= constrMethod;
						break;
					}
				}
			}
		}
		GenStubSettings settings= DbUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
		settings.createComments= isAddComments();
		
		final String delimiter= getLineDelimiter();
		StringBuffer buffer= new StringBuffer(32);
		if (methodTemplate != null) {
			settings.callSuper= true;				
			settings.methodOverwrites= true;
			content= DbUnitStubUtility.genStub(type.getCompilationUnit(), getTypeName(), methodTemplate, settings, null, imports);
		} else {
			buffer.append("public "); //$NON-NLS-1$
			buffer.append(getTypeName());
			buffer.append('(');
			if (!isJUnit4()) {
				buffer.append(imports.addImport("java.lang.String")).append(" name"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			buffer.append(") {"); //$NON-NLS-1$
			buffer.append(delimiter);
			if (!isJUnit4()) {
				buffer.append("super(name);").append(delimiter); //$NON-NLS-1$
			}
			if (this.fSelectedProfile == null) {
				buffer.append('}');
				buffer.append(delimiter);
				content= buffer.toString();
			}
		}
		if (this.fSelectedProfile != null) {
			imports.addImport("org.dbunit.PropertiesBasedJdbcDatabaseTester"); //$NON-NLS-1$
			String driverClass = 
				this.fSelectedProfile.getBaseProperties().getProperty(IDBDriverDefinitionConstants.DRIVER_CLASS_PROP_ID);
			String driverURL = 
				this.fSelectedProfile.getBaseProperties().getProperty(IDBDriverDefinitionConstants.URL_PROP_ID);
			driverURL = sanitizeURL(driverURL);
			String userName = 
				this.fSelectedProfile.getBaseProperties().getProperty(IDBDriverDefinitionConstants.USERNAME_PROP_ID);
			
			String dcLine =
				"\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_DRIVER_CLASS, \"" + //$NON-NLS-1$
				driverClass + "\" );" + //$NON-NLS-1$
				delimiter;
			String urlLine =
				"\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_CONNECTION_URL, \"" + //$NON-NLS-1$
				driverURL + "\" );" + //$NON-NLS-1$
				delimiter;
			String uidLine =
				"\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_USERNAME, \"" + //$NON-NLS-1$
				userName + "\" );" + //$NON-NLS-1$
				delimiter;
			String pwdLine =
				"\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_PASSWORD, \"\" );" +	delimiter; //$NON-NLS-1$
			if (content != null && content.lastIndexOf("}") > -1) { //$NON-NLS-1$
				StringBuffer buffer2 = new StringBuffer(content);
				buffer2.insert(buffer2.lastIndexOf("}") - 2, delimiter); //$NON-NLS-1$
				buffer2.insert(buffer2.lastIndexOf("}") - 2, dcLine); //$NON-NLS-1$
				buffer2.insert(buffer2.lastIndexOf("}") - 2, urlLine); //$NON-NLS-1$
				buffer2.insert(buffer2.lastIndexOf("}") - 2, uidLine); //$NON-NLS-1$
				buffer2.insert(buffer2.lastIndexOf("}") - 2, pwdLine); //$NON-NLS-1$
				content = buffer2.toString();
			}
			else {
				buffer.append(dcLine);
				buffer.append(urlLine);
				buffer.append(uidLine);
				buffer.append(pwdLine);
				buffer.append('}');
				content = buffer.toString();
			}
		}
		type.createMethod(content, null, true, null);	
	}
	
	/**
	 * @param inURL
	 * @return
	 */
	private String sanitizeURL( String inURL) {
		String outURL = ""; //$NON-NLS-1$
		char ch;
		for (int i=0;i<inURL.length();i++) // scan each character of string
		{
			ch = inURL.charAt(i);   // extract the character
			switch (ch)
			{
			case '\\': 
				outURL += "\\" + "\\";  // double slashes //$NON-NLS-1$ //$NON-NLS-2$
				break;
			case '\"': 
				outURL += "\"" + "\"";  // double double quotes //$NON-NLS-1$ //$NON-NLS-2$
				break;
			default: outURL += ch;  // add to result
			}
		}
		return outURL;
	}

	/**
	 * @param type
	 * @param imports
	 * @throws CoreException
	 */
	private void createGetDataSet(IType type, ImportsManager imports) throws CoreException {
		imports.addImport("java.io.FileInputStream"); //$NON-NLS-1$
		imports.addImport("org.dbunit.dataset.xml.FlatXmlDataSet"); //$NON-NLS-1$
		
		String returnClause = "return new FlatXmlDataSet(new FileInputStream("; //$NON-NLS-1$
		if (fInitialDataSetText != null && fInitialDataSetText.getText().length() > 0) {
			String fileName = sanitizeURL(fInitialDataSetText.getText());
			returnClause = returnClause + "\"" + fileName + "\"));"; //$NON-NLS-1$ //$NON-NLS-2$
		}
		else {
			returnClause = returnClause + "\"dataset.xml\"));"; //$NON-NLS-1$
		}
		
		createSetupStubs(type, "getDataSet", false, "org.junit.Before", imports, //$NON-NLS-1$ //$NON-NLS-2$ 
				IDataSet.class, false, returnClause);
	}
	
	/**
	 * @param type
	 * @param imports
	 * @throws CoreException
	 */
	private void createGetSetupOperation(IType type, ImportsManager imports) throws CoreException {
		createSetupStubs(type, "getSetUpOperation", false, "org.junit.Before", imports, DatabaseOperation.class, true); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	/**
	 * @param type
	 * @param imports
	 * @throws CoreException
	 */
	private void createGetTeardownOperation(IType type, ImportsManager imports) throws CoreException {
		createSetupStubs(type, "getTearDownOperation", true, "org.junit.Before", imports, DatabaseOperation.class, true); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	/**
	 * @return
	 * @throws JavaModelException
	 */
	private String getLineDelimiter() throws JavaModelException{
		IType classToTest= getClassUnderTest();
		
		if (classToTest != null && classToTest.exists() && classToTest.getCompilationUnit() != null)
			return classToTest.getCompilationUnit().findRecommendedLineSeparator();
		
		return getPackageFragment().findRecommendedLineSeparator();
	}

	/**
	 * @param type
	 * @param methodName
	 * @return
	 * @throws JavaModelException
	 */
	private IMethod findInHierarchy(IType type, String methodName) throws JavaModelException {
		ITypeHierarchy typeHierarchy= null;
		IType[] superTypes= null;
		if (type.exists()) {
			typeHierarchy= type.newSupertypeHierarchy(null);
			superTypes= typeHierarchy.getAllSuperclasses(type);
			for (int i= 0; i < superTypes.length; i++) {
				if (superTypes[i].exists()) {
					IMethod testMethod= superTypes[i].getMethod(methodName, new String[] {});
					if (testMethod.exists()) {
						return testMethod;
					}
				}
			}
		}
		return null;
	}

	/*
	 * Browse for a location, with the location passed in as the default
	 */
	private String handleLocationEditButtonPressed(String editLocation) {
		
		IContainer root = ResourcesPlugin.getWorkspace().getRoot();

		refreshProject();
		
		ResourceChooserDialog rsDialog = new ResourceChooserDialog(getShell(), 
				root, true,
				DbUnitMessages.NewDbUnitTestCaseWizardPage1_Dialog_Text,
				true);
		rsDialog.setTitle(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Dialog_Title);
		rsDialog.showClosedProjects(false);
		rsDialog.setValidator(new IDataSelectionValidator() {

			public String isValid(IStructuredSelection selection) {
				if (selection.isEmpty())
					return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Select_Dataset;
				if (selection.size() > 1) {
					return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Select_One_Dataset;
				}
				if (selection.getFirstElement() instanceof IProject) {
					return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
				}
				if (!(selection.getFirstElement() instanceof IFile))
					return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
				IFile testFile = (IFile) selection.getFirstElement();
				if (!testFile.getFileExtension().equals("xml"))  //$NON-NLS-1$
					return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
				return null;
			}
		});

		int rtn = rsDialog.open();
		if (rtn == Window.OK) {
			Object[] selectedDirectory = rsDialog.getResult();
			if (selectedDirectory != null) {
				if (selectedDirectory.length > 0){
					StructuredSelection selection = (StructuredSelection) selectedDirectory[0];
					IResource resource = (IResource) selection.getFirstElement();
					return resource.getLocation().toOSString();
				}
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#superClassChanged()
	 */
	protected IStatus superClassChanged() {

		refreshProject();
		return super.superClassChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.NewTypeWizardPage#typeNameChanged()
	 */
	protected IStatus typeNameChanged() {
		fSuperClassStatus = superClassChanged();
		return super.typeNameChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne#handleFieldChanged(java.lang.String)
	 */
	protected void handleFieldChanged(String fieldName) {
		super.handleFieldChanged(fieldName);
		if (fieldName.equals(JUNIT4TOGGLE)) {
			setSuperClass(DEFAULT_DBUNIT_SUPERCLASS, true);
		}
		if (fieldName.equals(PROFILE_CHANGED)) {
			this.fProfileUnderTestStatus = profileUnderTestChanged();
		}
		updateStatus(getStatusList());
	}

	protected void updateStatus(IStatus[] status) {
		super.updateStatus(getMostSevere(status));
	}	

	public static IStatus getMostSevere(IStatus[] status) {
		IStatus max= null;
		for (int i= 0; i < status.length; i++) {
			IStatus curr= status[i];
			if (curr != null) {
				if (curr.matches(IStatus.ERROR)) {
					return curr;
				}
				if (max == null || curr.getSeverity() > max.getSeverity()) {
					max= curr;
				}
			}
		}
		return max;
	}
	/**
	 * 
	 */
	public void refreshProject() {
		IPackageFragmentRoot root = getPackageFragmentRoot();
		if (root != null) {
			IJavaProject jproject = root.getJavaProject();
			IProject project = jproject.getProject();
			try {
				project.refreshLocal(IResource.DEPTH_ONE, null);
				jproject.makeConsistent(null);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			
		}
	}
}
