/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.util;

import java.text.MessageFormat;

/**
 * Helper class to format message strings.
 */
public class Messages {

	/**
	 * @param message
	 * @param object
	 * @return
	 */
	public static String format(String message, Object object) {
		return MessageFormat.format(message, new Object[] { object});
	}

	/**
	 * @param message
	 * @param objects
	 * @return
	 */
	public static String format(String message, Object[] objects) {
		return MessageFormat.format(message, objects);
	}

	/**
	 * 
	 */
	private Messages() {
		// Not for instantiation
	}
}