/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.BuildPathSupport;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.preference.PreferenceConstants;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	private static String DBUNIT_PLUGIN_PATH = 
		BuildPathSupport.getBundleLocation(Activator.DBUNIT_PLUGIN_ID).
			makeAbsolute().append(BuildPathSupport.DBUNIT2_LIBS_DIR).toOSString();
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault()
				.getPreferenceStore();
		store.setDefault(PreferenceConstants.P_DBUNIT_PATH,
				DBUNIT_PLUGIN_PATH);
		store.setDefault(PreferenceConstants.P_DBUNIT_SRC_PATH,
				DBUNIT_PLUGIN_PATH);
	}

}
