/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.preference;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.preference.PreferenceConstants;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;

/**
 * @author brianf
 *
 */
public class DbUnitPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

	private PathDirectoryFieldEditor mPathEditor = null;
	private PathDirectoryFieldEditor mSrcPathEditor = null;

	/**
	 * @author brianf
	 *
	 */
	private class PathDirectoryFieldEditor extends DirectoryFieldEditor {
		public PathDirectoryFieldEditor (String name, String labelText, Composite parent) {
			super(name, labelText, parent);
			this.setValidateStrategy(DirectoryFieldEditor.VALIDATE_ON_KEY_STROKE);
		}
	}
	
	/**
	 * 
	 */
	public DbUnitPreferencePage() {
		super(GRID);
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
		setDescription(DbUnitMessages.DbUnitPreferencePage_Description);
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		
		mPathEditor = new PathDirectoryFieldEditor(PreferenceConstants.P_DBUNIT_PATH, 
				DbUnitMessages.DbUnitPreferencePage_LibraryPath_Label, getFieldEditorParent()); 
		addField(mPathEditor);
		
		mSrcPathEditor = new PathDirectoryFieldEditor(PreferenceConstants.P_DBUNIT_SRC_PATH, 
				DbUnitMessages.DbUnitPreferencePage_SourcePath_Label, getFieldEditorParent());
		addField(mSrcPathEditor);
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	
}