/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.export;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.sql.DataSource;

import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileConnectionManager;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.export.DBUnitDataExtractor;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.export.ExportDBUDataSetObjectSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;

/**
 * @author brianf
 *
 */
public class ExportDBUDataSetWizard extends BaseWizard {

	private ExportDBUDataSetObjectSelectionPage page1 = null;
	protected SummaryWizardPage mSummaryPage;
	protected Object mIncomingObject;
	private IConnection mConnection = null;
	private DatabaseConnection mDBConnection = null;
	private boolean hadToOpen = false;
	
	/**
	 * @param incoming
	 */
	public ExportDBUDataSetWizard ( Object incoming ) {
		super();
		this.mIncomingObject = incoming;
	}

	/**
	 * @return
	 */
	public Object getIncomingObject() {
		return this.mIncomingObject;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages() {
		page1 = new ExportDBUDataSetObjectSelectionPage("page1"); //$NON-NLS-1$
		addPage(page1);

		mSummaryPage = new SummaryWizardPage(this);
		addPage(mSummaryPage);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		try {
			writeDataSet();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	/**
	 * @return
	 * @throws Exception
	 */
	protected IDatabaseConnection getConnection() throws Exception {
		IConnectionProfile icp = page1.getProfile(); //ProfileManager.getInstance().getProfileByName("asa2");
		mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(icp, Connection.class.getName()); //$NON-NLS-1$
		if (mConnection == null) {
			ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(icp, Connection.class.getName(), Activator.getDefault()); //$NON-NLS-1$
			icp.connect();
			mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(icp, Connection.class.getName()); //$NON-NLS-1$
		}
		Connection jdbcConnection = (Connection) mConnection.getRawConnection();
		mDBConnection = new DatabaseConnection(jdbcConnection);
		return mDBConnection;
	}
	
	/**
	 * @author brianf
	 *
	 */
	private class MyDataSource implements DataSource {

		private IConnectionProfile mProfile = null;
		private IConnection mConnection = null;
		private Connection mJDBCConnection = null;
		
		/**
		 * 
		 */
		public MyDataSource() {
			mProfile = null;
		}
		
		/**
		 * @param icp
		 */
		public MyDataSource ( IConnectionProfile icp ) {
			mProfile = icp;
		}
		
		/**
		 * @param icp
		 */
		public void setConnectionProfile ( IConnectionProfile icp) {
			mProfile = icp;
		}
		
		/* (non-Javadoc)
		 * @see javax.sql.DataSource#getConnection()
		 */
		public Connection getConnection() throws SQLException {
			mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(mProfile, Connection.class.getName()); //$NON-NLS-1$
			if (mConnection == null) {
				hadToOpen = true;
				ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(mProfile, Connection.class.getName(), Activator.getDefault()); //$NON-NLS-1$
				mProfile.connect();
				mConnection = ProfileConnectionManager.getProfileConnectionManagerInstance().getConnection(mProfile, Connection.class.getName()); //$NON-NLS-1$
			}
			mJDBCConnection = (Connection) mConnection.getRawConnection();
			return mJDBCConnection;
		}

		/* (non-Javadoc)
		 * @see javax.sql.DataSource#getConnection(java.lang.String, java.lang.String)
		 */
		public Connection getConnection(String username, String password) throws SQLException {
			return getConnection();
		}

		/* (non-Javadoc)
		 * @see javax.sql.DataSource#getLogWriter()
		 */
		public PrintWriter getLogWriter() throws SQLException {
			return null;
		}

		/* (non-Javadoc)
		 * @see javax.sql.DataSource#getLoginTimeout()
		 */
		public int getLoginTimeout() throws SQLException {
			return 0;
		}

		/* (non-Javadoc)
		 * @see javax.sql.DataSource#setLogWriter(java.io.PrintWriter)
		 */
		public void setLogWriter(PrintWriter out) throws SQLException {
		}

		/* (non-Javadoc)
		 * @see javax.sql.DataSource#setLoginTimeout(int)
		 */
		public void setLoginTimeout(int seconds) throws SQLException {
		}
		
	}

	/**
	 * @throws Exception
	 */
	protected void writeDataSet() throws Exception {

		boolean hasSchema = false;
		boolean allInSameSchema = true;
		Schema inSchema = null;
		if (this.mIncomingObject instanceof Schema) {
			hasSchema = true;
			inSchema = (Schema) this.mIncomingObject;
		}
        Object[] selectedTables = page1.getSelectedObjects();
        ArrayList stringTables = new ArrayList();

        for (int i = 0; i < selectedTables.length; i++) {
        	Table table = (Table)selectedTables[i];
        	if (allInSameSchema) {
        		if (!table.getSchema().equals(inSchema)) 
        			allInSameSchema = false;
        	}
        	if (hasSchema)
        		stringTables.add(((Table)selectedTables[i]).getName());
        	else {
        		stringTables.add(ExportDBUDataSetObjectSelectionPage.getQualifiedTableName((Table)selectedTables[i], true, true));
        	}
        }

		DBUnitDataExtractor extractor = new DBUnitDataExtractor();
		extractor.setDataSource(new MyDataSource(page1.getProfile()));
		extractor.setDataSetName(page1.getFileName());
		HashMap properties = new HashMap();
		properties.put(DatabaseConfig.PROPERTY_TABLE_TYPE, new String[] {"SYSTEM TABLE", "TABLE", "VIEW"}); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		extractor.setDbUnitProperties(properties);
		
		HashMap features = new HashMap();
		features.put(DatabaseConfig.FEATURE_DATATYPE_WARNING, "false"); //$NON-NLS-1$
		if (!hasSchema) 
			features.put(DatabaseConfig.FEATURE_QUALIFIED_TABLE_NAMES, "true"); //$NON-NLS-1$
		extractor.setDbUnitFeatures(features);
		
		if (hasSchema && !allInSameSchema) {
			extractor.setSchema(((Schema)mIncomingObject).getName());
		}
		extractor.setTableList(stringTables);
		extractor.extract(hadToOpen);
		
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(IResource.DEPTH_INFINITE, null);
	}
}
