/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Simple filename filter to check for files that match 
 * a particular pattern (such as "common*.jar")
 * @author brianf
 *
 */
public class MyFilenameFilter implements FilenameFilter {

	private String pattern = null;
	
	/**
	 * @param pattern
	 */
	public MyFilenameFilter( String pattern ) {
		this.pattern = pattern;
	}
	
	/* (non-Javadoc)
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public boolean accept(File dir, String name) {
		if (name.matches(pattern))
			return true;
		return false;
	}

}
