/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;


import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.preference.PreferenceConstants;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/**
 * @author brianf
 *
 */
public class DbUnitHomeInitializer extends ClasspathVariableInitializer {	
	
	public static String DBUNIT_HOME = "DBUNIT_HOME"; //$NON-NLS-1$
	public static String DBUNIT_SRC_HOME = "DBUNIT_SRC_HOME"; //$NON-NLS-1$
	
	/*
	 * @see ClasspathVariableInitializer#initialize(String)
	 */
	public void initialize(String variable) {
		if (DBUNIT_HOME.equals(variable)) {
			initializeHome();
		} else if (DBUNIT_SRC_HOME.equals(variable)) {
			initializeSource();
		}
	}

	/**
	 * 
	 */
	private void initializeHome() {
		try {
			String homePath =
				Activator.getDefault().getPreferenceStore().getString(PreferenceConstants.P_DBUNIT_PATH);
			IPath location = Path.fromOSString(homePath);
//			IPath location= BuildPathSupport.getBundleLocation(BuildPathSupport.DBUNIT2_PLUGIN_ID);
			if (location != null) {
				JavaCore.setClasspathVariable(DBUNIT_HOME, location, null);
			} else {
				JavaCore.removeClasspathVariable(DBUNIT_HOME, null);
			}
		} catch (JavaModelException e1) {
			JavaCore.removeClasspathVariable(DBUNIT_HOME, null);
		}
	}
	
	/**
	 * 
	 */
	private void initializeSource() {
		try {
			String srcPath =
				Activator.getDefault().getPreferenceStore().getString(PreferenceConstants.P_DBUNIT_SRC_PATH);
			IPath sourceLocation = Path.fromOSString(srcPath);
//			IPath sourceLocation= BuildPathSupport.getSourceLocation(BuildPathSupport.DBUNIT2_PLUGIN_ID);
			if (sourceLocation != null) {
				JavaCore.setClasspathVariable(DBUNIT_SRC_HOME, sourceLocation, null);
			} else {
				JavaCore.removeClasspathVariable(DBUNIT_SRC_HOME, null);
			}
		} catch (JavaModelException e1) {
			JavaCore.removeClasspathVariable(DBUNIT_SRC_HOME, null);
		}
	}
}