/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitPluginImages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStatus;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.PixelConverter;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * @author brianf
 *
 */
public class DbUnitContainerWizardPage extends NewElementWizardPage implements IClasspathContainerPage, IClasspathContainerPageExtension {

	private IClasspathEntry fContainerEntryResult;
	private Label fResolvedPath;

	/**
	 * 
	 */
	public DbUnitContainerWizardPage() {
		super("DbUnitContainerPage"); //$NON-NLS-1$
		setTitle(DbUnitMessages.DbUnitContainerWizardPage_wizard_title);
		setDescription(DbUnitMessages.DbUnitContainerWizardPage_wizard_description);
		setImageDescriptor(DbUnitPluginImages.DESC_WIZBAN_ADD_LIBRARY);
		
		fContainerEntryResult= JavaCore.newContainerEntry(DbUnitContainerInitializer.DBUNIT2_PATH);
	}

	/**
	 * @return
	 */
	public static IJavaProject getPlaceholderProject() {
		String name= "####internal"; //$NON-NLS-1$
		IWorkspaceRoot root= ResourcesPlugin.getWorkspace().getRoot();
		while (true) {
			IProject project= root.getProject(name);
			if (!project.exists()) {
				return JavaCore.create(project);
			}
			name += '1';
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#finish()
	 */
	public boolean finish() {
		try {
			IJavaProject[] javaProjects= new IJavaProject[] { getPlaceholderProject() };
			IClasspathContainer[] containers= { null };
			JavaCore.setClasspathContainer(fContainerEntryResult.getPath(), javaProjects, containers, null);
		} catch (JavaModelException e) {
			ExceptionHandler.showException(getShell(), 
					DbUnitMessages.DbUnitContainerWizardPage_error_title, 
					DbUnitMessages.DbUnitContainerWizardPage_error_problem_configuring_container, e);
			return false;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#getSelection()
	 */
	public IClasspathEntry getSelection() {
		return fContainerEntryResult;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#setSelection(org.eclipse.jdt.core.IClasspathEntry)
	 */
	public void setSelection(IClasspathEntry containerEntry) {
		fContainerEntryResult= containerEntry;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		PixelConverter converter= new PixelConverter(parent);
		
		Composite composite= new Composite(parent, SWT.NONE);
		composite.setFont(parent.getFont());
		
		composite.setLayout(new GridLayout(2, false));
		
		Label label= new Label(composite, SWT.NONE);
		label.setFont(composite.getFont());
		label.setText(DbUnitMessages.DbUnitContainerWizardPage_resolved_label);
		label.setLayoutData(new GridData(GridData.FILL, GridData.BEGINNING, false, false, 1, 1));
		
		fResolvedPath= new Label(composite, SWT.WRAP);
		GridData data= new GridData(GridData.FILL, GridData.FILL, true, false, 1, 1);
		data.widthHint= converter.convertWidthInCharsToPixels(60);
		fResolvedPath.setFont(composite.getFont());
		fResolvedPath.setLayoutData(data);
		
		doSelectionChanged();
		
		setControl(composite);
	}

	/**
	 * 
	 */
	protected void doSelectionChanged() {
		DbUnitStatus status= new DbUnitStatus();
		
		IClasspathEntry libEntry;
		IPath containerPath;
		containerPath= DbUnitContainerInitializer.DBUNIT2_PATH;
		libEntry= BuildPathSupport.getDbUnit2LibraryEntry();
		
		if (libEntry == null) {
			status.setError(DbUnitMessages.DbUnitContainerWizardPage_error_version_not_available);
		} 
		fContainerEntryResult= JavaCore.newContainerEntry(containerPath);
		
		if (fResolvedPath != null && !fResolvedPath.isDisposed()) {
			if (libEntry != null) {
				fResolvedPath.setText(libEntry.getPath().toOSString());
			} else {
				fResolvedPath.setText(new String());
			}
		}
		updateStatus(status);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension#initialize(org.eclipse.jdt.core.IJavaProject, org.eclipse.jdt.core.IClasspathEntry[])
	 */
	public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
	}

}
