/*******************************************************************************
 * Copyright (c) 2007 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Brian Fitzpatrick - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;

import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/**
 * @author brianf
 *
 */
public class DbUnitContainerInitializer extends ClasspathContainerInitializer {
	
	public static final String DBUNIT_CONTAINER_ID= "org.eclipse.datatools.enablement.jdt.dbunit.DBUNIT_CONTAINER"; //$NON-NLS-1$
	
	public final static String DBUNIT2= "2.2"; //$NON-NLS-1$
	
	public final static String DBUNIT2_LIBS_DIR = "libs";//$NON-NLS-1$
	
	public final static IPath DBUNIT2_PATH= new Path(DBUNIT_CONTAINER_ID).append(DBUNIT2_LIBS_DIR).append(DBUNIT2);
	
	/**
	 * @author brianf
	 *
	 */
	private static class DbUnitContainer implements IClasspathContainer {
		
		private final IClasspathEntry[] fEntries;
		private final IPath fPath;

		/**
		 * @param path
		 * @param entries
		 */
		public DbUnitContainer(IPath path, IClasspathEntry[] entries) {
			fPath= path;
			fEntries= entries;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jdt.core.IClasspathContainer#getClasspathEntries()
		 */
		public IClasspathEntry[] getClasspathEntries() {
			return fEntries;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jdt.core.IClasspathContainer#getDescription()
		 */
		public String getDescription() {
			return DbUnitMessages.DbUnitContainerInitializer_description_dbunit2;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jdt.core.IClasspathContainer#getKind()
		 */
		public int getKind() {
			return IClasspathContainer.K_APPLICATION;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jdt.core.IClasspathContainer#getPath()
		 */
		public IPath getPath() {
			return fPath;
		}
		
	}
	
	
	/**
	 * 
	 */
	public DbUnitContainerInitializer() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#initialize(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject)
	 */
	public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
		if (isValidDbUnitContainerPath(containerPath)) {

			IClasspathEntry entry= null;
			String version= containerPath.segment(1);
			if (DBUNIT2.equals(version)) {
				entry= BuildPathSupport.getDbUnit2LibraryEntry();
			}
			
			IClasspathEntry[] entries;
			if (entry != null) {
				entries= new IClasspathEntry[] { entry };
			} else {
				entries= new IClasspathEntry[] { };
			}
			
			DbUnitContainer container= new DbUnitContainer(containerPath, entries);
			JavaCore.setClasspathContainer(containerPath, new IJavaProject[] { project }, 	new IClasspathContainer[] { container }, null);
		}

	}
	
	/**
	 * @param path
	 * @return
	 */
	private static boolean isValidDbUnitContainerPath(IPath path) {
		return path != null && path.segmentCount() == 2 && DBUNIT_CONTAINER_ID.equals(path.segment(0));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#canUpdateClasspathContainer(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject)
	 */
	public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#requestClasspathContainerUpdate(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject, org.eclipse.jdt.core.IClasspathContainer)
	 */
	public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
		JavaCore.setClasspathContainer(containerPath, new IJavaProject[] { project }, 	new IClasspathContainer[] { containerSuggestion }, null);
	}

	/**
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#getDescription(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject)
	 */
	public String getDescription(IPath containerPath, IJavaProject project) {
		if (isValidDbUnitContainerPath(containerPath)) {
			String version= containerPath.segment(1);
			if (DBUNIT2.equals(version)) {
				return DbUnitMessages.DbUnitContainerInitializer_description_dbunit2;
			}
		}
		return DbUnitMessages.DbUnitContainerInitializer_description_initializer_unresolved;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.ClasspathContainerInitializer#getComparisonID(org.eclipse.core.runtime.IPath, org.eclipse.jdt.core.IJavaProject)
	 */
	public Object getComparisonID(IPath containerPath, IJavaProject project) {
		return containerPath;
	}
	
}
