/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.hsqldb.ui.properties;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.enablement.hsqldb.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HSQLDBPropertyPage
extends ProfileDetailsPropertyPage {
    private static final String EMPTY_STRING = new String();
    private Text mDatabaseNameText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Text mURLText;
    private Button mSaveDBPWDCheckbox;
    private Text mDBFilePathText;
    private Button mBrowseFilePathButton;
    final DriverListCombo combo = new DriverListCombo();
    private DelimitedStringList mDBConnProps;
    private DriverInstance mDriverInstance;
    private String mDriverCategory;

    public HSQLDBPropertyPage() {
        this.noDefaultAndApplyButton();
        this.setDriverCategory("org.eclipse.datatools.enablement.hsqldb.driver.category");
    }

    protected void createCustomContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(Messages.getString("HSQLDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.0"));
        Composite textAndBrowseComposite = new Composite(content, 0);
        GridLayout subCompositeLayout = new GridLayout(2, false);
        subCompositeLayout.marginLeft = -5;
        subCompositeLayout.marginRight = -5;
        subCompositeLayout.marginTop = -5;
        subCompositeLayout.marginBottom = -5;
        textAndBrowseComposite.setLayout((Layout)subCompositeLayout);
        textAndBrowseComposite.setLayoutData((Object)new GridData(768));
        this.mDBFilePathText = new Text(textAndBrowseComposite, 2048);
        this.mDBFilePathText.setLayoutData((Object)new GridData(768));
        this.mBrowseFilePathButton = new Button(textAndBrowseComposite, 8);
        this.mBrowseFilePathButton.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.1"));
        this.mBrowseFilePathButton.setLayoutData((Object)new GridData(128));
        this.mURLText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mDBUIDText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, Messages.getString("HSQLDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                HSQLDBPropertyPage.this.setErrorMessage(null);
                if (HSQLDBPropertyPage.this.mDBConnProps.getWarning() != null) {
                    HSQLDBPropertyPage.this.setErrorMessage(HSQLDBPropertyPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String oldPassword;
                String password;
                String oldUsername;
                HSQLDBPropertyPage.this.mDriverInstance = HSQLDBPropertyPage.this.combo.getSelectedDriverInstance();
                HSQLDBPropertyPage.this.setErrorMessage(null);
                if (HSQLDBPropertyPage.this.combo.getErrorMessage() != null) {
                    HSQLDBPropertyPage.this.setErrorMessage(HSQLDBPropertyPage.this.combo.getErrorMessage());
                } else {
                    HSQLDBPropertyPage.this.mURLText.setText(HSQLDBPropertyPage.this.getDriverURL());
                }
                String username = HSQLDBPropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                if ((oldUsername = HSQLDBPropertyPage.this.mDBUIDText.getText()) == null || oldUsername.trim().length() == 0) {
                    oldUsername = new String();
                }
                if (oldUsername.length() == 0) {
                    HSQLDBPropertyPage.this.mDBUIDText.setText(username);
                }
                if ((password = HSQLDBPropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password")) == null || password.trim().length() == 0) {
                    password = new String();
                }
                if ((oldPassword = HSQLDBPropertyPage.this.mDBPWDText.getText()) == null || oldPassword.trim().length() == 0) {
                    oldPassword = new String();
                }
                if (oldPassword.length() == 0) {
                    HSQLDBPropertyPage.this.mDBPWDText.setText(password);
                }
            }
        });
        this.initControls();
        this.mDBFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HSQLDBPropertyPage.this.updateURLFromProps();
            }
        });
        this.mBrowseFilePathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HSQLDBPropertyPage.this.browseForDBFolder();
            }

            public void widgetSelected(SelectionEvent e) {
                HSQLDBPropertyPage.this.browseForDBFolder();
            }
        });
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        String driverID = EMPTY_STRING;
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance instance = this.combo.getSelectedDriverInstance();
            driverID = instance.getId();
        }
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.mDBConnProps.getSelection());
        props.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.vendor"));
        props.setProperty("org.eclipse.datatools.connectivity.db.version", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.version"));
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.driverClass"));
        props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.mDatabaseNameText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.mDBPWDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.mDBUIDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", this.mURLText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.mSaveDBPWDCheckbox.getSelection()));
        return props;
    }

    private void initControls() {
        String urlText;
        String databaseUid;
        String databasePwd;
        String databaseName;
        String connectionProps;
        IConnectionProfile profile = this.getConnectionProfile();
        String driverID = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverID != null) {
            this.combo.setSelectionToID(driverID);
        }
        if ((connectionProps = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null) {
            this.mDBConnProps.setSelection(connectionProps);
        }
        if ((databaseName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName")) != null) {
            this.mDatabaseNameText.setText(databaseName);
        }
        if ((databasePwd = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.mDBPWDText.setText(databasePwd);
        }
        if ((databaseUid = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.mDBUIDText.setText(databaseUid);
        }
        if ((urlText = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL")) != null) {
            this.mURLText.setText(urlText);
            this.mURLText.setEnabled(false);
        }
        this.mSaveDBPWDCheckbox.setSelection(Boolean.valueOf(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.savePWD", Boolean.FALSE.toString())).booleanValue());
        this.updatePropsFromURL();
        this.setErrorMessage(null);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
    }

    private void browseForDBFolder() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.getString("HSQLDBProfileDetailsWizardPage.FileDialog.title.filebrowse"));
        dialog.setMessage(Messages.getString("HSQLDBProfileDetailsWizardPage.FileDialog.msg.filebrowse"));
        String dirName = this.mDBFilePathText.getText();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.mDBFilePathText.setText(selectedDirectory);
        }
    }

    private void updatePropsFromURL() {
        String[] chunks2;
        String url;
        String[] chunks;
        if (this.mDBFilePathText != null && this.mURLText != null && (chunks = this.parseString(url = this.mURLText.getText(), ";")).length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
            String filepath = chunks2[2];
            if (chunks2.length > 3) {
                filepath = filepath + ":" + chunks2[3];
            }
            this.mDBFilePathText.setText(filepath);
        }
    }

    private void updateURLFromProps() {
        if (this.mDBFilePathText != null && this.mURLText != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String filePath = this.mDBFilePathText.getText();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                url = chunks2[0] + ":" + chunks2[1] + ":" + filePath;
                this.mURLText.setText(url);
            }
        }
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public String getDriverURL() {
        return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return super.isValid();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }
}

