/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;

public class PropertySetImpl
implements IPropertySet {
    private Map mPropertiesMap;
    private String mName;
    private String mID;

    public PropertySetImpl(String name, String id) {
        this.mName = name;
        this.mID = id;
        this.mPropertiesMap = new HashMap();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String newName) {
        this.mName = newName;
    }

    public String getID() {
        return this.mID;
    }

    public void setID(String id) {
        if (this.getProperties(this.mID) != null) {
            Properties temp = this.getProperties(this.mID);
            this.mPropertiesMap.remove(this.getProperties(this.mID));
            this.setProperties(id, temp);
        }
        this.mID = id;
    }

    public Properties getBaseProperties() {
        return this.getProperties(this.mID);
    }

    public void setBaseProperties(Properties props) {
        this.setProperties(this.mID, props);
    }

    public Properties getProperties(String type) {
        return (Properties)this.mPropertiesMap.get(type);
    }

    public void setProperties(String type, Properties props) {
        this.mPropertiesMap.put(type, props);
    }

    public Object clone() {
        Properties cloneProps = (Properties)this.getBaseProperties().clone();
        PropertySetImpl cloned = new PropertySetImpl(this.mName, this.mID);
        cloned.setBaseProperties(cloneProps);
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertySetImpl) {
            PropertySetImpl compare = (PropertySetImpl)obj;
            return this.mID.equals(compare.getID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.mID != null) {
            return this.mID.hashCode();
        }
        return super.hashCode();
    }
}

