/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectAdapter;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class ProfileConnectionManager {
    private static ProfileConnectionManager mConnectionManager = null;
    private HashMap mManagedProfileKeyToConnections = new HashMap();
    private HashMap mManagedProfileKeyToClientSet = new HashMap();
    private HashMap mProfileToListenerSet = new HashMap();
    private HashMap mFactoryIDToListener = new HashMap();
    private MyProfileListener listener = new MyProfileListener();

    public ProfileConnectionManager() {
        ProfileManager.getInstance().addProfileListener(this.listener);
    }

    public static ProfileConnectionManager getProfileConnectionManagerInstance() {
        if (mConnectionManager == null) {
            mConnectionManager = new ProfileConnectionManager();
        }
        return mConnectionManager;
    }

    public void manageProfileConnection(IConnectionProfile profile, String factoryID, Object client) {
        ManagedProfileKey key = new ManagedProfileKey(profile, factoryID);
        if (!this.mManagedProfileKeyToConnections.containsKey(key)) {
            HashSet<IConnectListener> listeners;
            IConnection con = this.createConnection(profile, factoryID);
            this.mManagedProfileKeyToConnections.put(key, con);
            this.mManagedProfileKeyToClientSet.put(key, new HashSet());
            IConnectListener listener = (IConnectListener)this.mFactoryIDToListener.get(factoryID);
            if (listener == null) {
                listener = new ProfileConnectListener(factoryID);
                this.mFactoryIDToListener.put(factoryID, listener);
            }
            if ((listeners = (HashSet<IConnectListener>)this.mProfileToListenerSet.get(profile)) == null) {
                listeners = new HashSet<IConnectListener>();
                this.mProfileToListenerSet.put(profile, listeners);
            }
            listeners.add(listener);
            profile.addConnectListener(listener);
        }
        ((Set)this.mManagedProfileKeyToClientSet.get(key)).add(client);
    }

    public void unmanageProfileConnection(IConnectionProfile profile, String factoryID, Object client) {
        ManagedProfileKey key = new ManagedProfileKey(profile, factoryID);
        if (this.mManagedProfileKeyToConnections.containsKey(key)) {
            Set clientSet = (Set)this.mManagedProfileKeyToClientSet.get(key);
            clientSet.remove(client);
            if (clientSet.size() == 0) {
                IConnection con = (IConnection)this.mManagedProfileKeyToConnections.get(key);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                this.mManagedProfileKeyToConnections.remove(key);
                this.mManagedProfileKeyToClientSet.remove(key);
                IConnectListener listener = (IConnectListener)this.mFactoryIDToListener.get(factoryID);
                profile.removeConnectListener(listener);
                ((Set)this.mProfileToListenerSet.get(profile)).remove(listener);
            }
        }
    }

    public IConnection getConnection(IConnectionProfile profile, String factoryID) {
        ManagedProfileKey key = new ManagedProfileKey(profile, factoryID);
        if (this.mManagedProfileKeyToConnections.containsKey(key)) {
            return (IConnection)this.mManagedProfileKeyToConnections.get(key);
        }
        return null;
    }

    private IConnection createConnection(IConnectionProfile icp, String factoryID) {
        IConnection con = null;
        if (icp.getConnectionState() == 1) {
            con = icp.createConnection(factoryID);
        }
        return con;
    }

    private static class ManagedProfileKey {
        private IConnectionProfile mProfile;
        private String mFactoryID;

        public ManagedProfileKey(IConnectionProfile profile, String factoryID) {
            this.mProfile = profile;
            this.mFactoryID = factoryID;
        }

        public IConnectionProfile getConnectionProfile() {
            return this.mProfile;
        }

        public String getFactoryID() {
            return this.mFactoryID;
        }

        public boolean equals(Object object) {
            if (object instanceof ManagedProfileKey) {
                ManagedProfileKey other = (ManagedProfileKey)object;
                return this.mProfile.equals(other.mProfile) && this.mFactoryID.equals(other.mFactoryID);
            }
            return false;
        }

        public int hashCode() {
            return this.mProfile.hashCode();
        }
    }

    private class ProfileConnectListener
    extends ConnectAdapter {
        private String mFactoryID;

        public ProfileConnectListener(String factoryID) {
            this.mFactoryID = factoryID;
        }

        public String getFactoryID() {
            return this.mFactoryID;
        }

        public boolean okToClose(ConnectEvent event) {
            ManagedProfileKey key = new ManagedProfileKey(event.getConnectionProfile(), this.mFactoryID);
            if (ProfileConnectionManager.this.mManagedProfileKeyToClientSet.containsKey(key)) {
                Iterator it = ((Set)ProfileConnectionManager.this.mManagedProfileKeyToClientSet.get(key)).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof IConnectListener) || ((IConnectListener)obj).okToClose(event)) continue;
                    return false;
                }
            }
            return true;
        }

        public void closeConnection(ConnectEvent event) throws CoreException {
            ManagedProfileKey key = new ManagedProfileKey(event.getConnectionProfile(), this.mFactoryID);
            if (ProfileConnectionManager.this.mManagedProfileKeyToConnections.containsKey(key)) {
                Iterator it = ((Set)ProfileConnectionManager.this.mManagedProfileKeyToClientSet.get(key)).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof IConnectListener)) continue;
                    try {
                        ((IConnectListener)obj).closeConnection(event);
                    }
                    catch (CoreException e) {}
                }
                IConnection con = (IConnection)ProfileConnectionManager.this.mManagedProfileKeyToConnections.get(key);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    ProfileConnectionManager.this.mManagedProfileKeyToConnections.put(key, null);
                }
            }
        }

        public void openConnection(ConnectEvent event) throws CoreException {
            ManagedProfileKey key = new ManagedProfileKey(event.getConnectionProfile(), this.mFactoryID);
            if (ProfileConnectionManager.this.mManagedProfileKeyToConnections.containsKey(key)) {
                IConnection con = (IConnection)ProfileConnectionManager.this.mManagedProfileKeyToConnections.get(key);
                if (con == null || con.getConnectException() != null) {
                    con = event.getConnectionProfile().createConnection(this.mFactoryID);
                    if (con.getConnectException() == null) {
                        ProfileConnectionManager.this.mManagedProfileKeyToConnections.put(key, con);
                    } else {
                        throw new CoreException((IStatus)new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), 10001, ConnectivityPlugin.getDefault().getResourceString("error.connect", new String[]{event.getConnectionProfile().getName()}), con.getConnectException()));
                    }
                }
                Iterator it = ((Set)ProfileConnectionManager.this.mManagedProfileKeyToClientSet.get(key)).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof IConnectListener)) continue;
                    try {
                        ((IConnectListener)obj).openConnection(event);
                    }
                    catch (CoreException e) {}
                }
            }
        }
    }

    private class MyProfileListener
    implements IProfileListener {
        private MyProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
            if (!ProfileConnectionManager.this.mProfileToListenerSet.containsKey(profile)) {
                return;
            }
            Iterator it = ((Set)ProfileConnectionManager.this.mProfileToListenerSet.get(profile)).iterator();
            while (it.hasNext()) {
                IConnection con;
                ProfileConnectListener listener = (ProfileConnectListener)it.next();
                ManagedProfileKey key = new ManagedProfileKey(profile, listener.getFactoryID());
                profile.removeConnectListener(listener);
                if (ProfileConnectionManager.this.mManagedProfileKeyToConnections.containsKey(profile) && (con = (IConnection)ProfileConnectionManager.this.mManagedProfileKeyToConnections.get(key)) != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                ProfileConnectionManager.this.mManagedProfileKeyToConnections.remove(key);
                ProfileConnectionManager.this.mManagedProfileKeyToClientSet.remove(key);
            }
            ProfileConnectionManager.this.mProfileToListenerSet.remove(profile);
        }

        public void profileChanged(IConnectionProfile profile) {
            if (ProfileConnectionManager.this.mManagedProfileKeyToConnections.containsKey(profile)) {
                // empty if block
            }
        }
    }
}

