/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.swt.widgets.Display;


/**
 * @author ljulien
 */
public class ServerExplorerConnectionManagedListener // implements ConnectionManagerListener
{
    private static final IServicesManager manager = IServicesManager.INSTANCE;
//    private static final ConnectionManager connectionManager = RDBCorePlugin.getDefault().getConnectionManager();

    private Map sharingListenerMap = new HashMap ();
   
    private ConnectionInfo getConnectionInfo (String name)
    {
        for (Iterator iterator = sharingListenerMap.keySet().iterator(); iterator.hasNext (); )
        {
            ConnectionInfo info = (ConnectionInfo) iterator.next();
            if (info.getName().equals(name))
            {
                return info;
            }
        }
        return null;
    }
  
    private void removeConnectionFromMap (ConnectionInfo info)
    {
        if (this.sharingListenerMap.containsKey(info))
        {
            System.out.println("Removing Info from map"); //$NON-NLS-1$
            ConnectionSharingListener listener = (ConnectionSharingListener) this.sharingListenerMap.get(info);
            info.removeConnectionSharingListener(listener);
            this.sharingListenerMap.remove(info);
        }
    }
    
    public void dispose ()
    {
 //       ConnectionInfo [] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
//        for (int i = 0, n = infos.length; i < n; i++)
//        {
//            ConnectionInfo info = infos[i];
//            if (info.getSharedDatabase() != null)
//            {
//                info.removeSharedDatabase();
//            }
//            if (info.getSharedConnection() != null)
//            {
//                info.removeSharedConnection();
//            }
//            removeConnectionFromMap (infos[i]);
//        }
    }
    
    public void connectionInfoCreated(final ConnectionInfo info)
    {
    	Display.getDefault().syncExec(new Runnable ()
		{
    		public void run ()
    		{
    	        System.out.println ("connectionInfoCreated"); //$NON-NLS-1$
    	        if (!sharingListenerMap.containsKey(info))
    	        {
    	            System.out.println ("Adding new Info to Map"); //$NON-NLS-1$
    	            ConnectionSharingListener listener = new ServerExplorerConnectionSharingListener ();
    	            info.addConnectionSharingListener(listener);
    	            sharingListenerMap.put(info, listener);
    	            new ServerExplorerInitializer ().displayNewConnection(info.getName(), info);
    	        }
    		}
		});
    }

    public void connectionInfoRemoved(final String name)
    {
    	Display.getDefault().syncExec(new Runnable ()
		{
    		public void run ()
    		{
    	        System.out.println ("connectionInfoRemoved"); //$NON-NLS-1$
    	        ConnectionInfo info = getConnectionInfo (name);
    	        removeConnectionFromMap(info); 
    	        if (info != null)
    	        {
    	            try
    	            {
    	                IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
    	                IServicesManager.INSTANCE.getServerExplorerContentService().deleteServer(new IConnectionNode[] { node });
    	            }
    	            catch (ServerNotFoundException e)
    	            {
    	            }
    	        }
    		}
		});
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info)
    {
        System.out.println ("connectionInfoRenamed"); //$NON-NLS-1$
    }

    public void connected(final ConnectionInfo info, final Connection connection)
    {
    	Display.getDefault().syncExec(new Runnable ()
		{
    		public void run ()
    		{
    	        System.out.println ("connected"); //$NON-NLS-1$
    	        new ServerExplorerInitializer ().displayNewConnection(info.getName(), info);
    		}
		});
    }

    public void disconnected(final ConnectionInfo info, final Connection connection)
    {
    	Display.getDefault().syncExec(new Runnable ()
		{
    		public void run ()
    		{
    	        try
		        {
		            System.out.println ("disconnected"); //$NON-NLS-1$
		            IConnectionNode connectionNode = ConnectionNodeUtil.getConnectionNode(info);
		            IServicesManager.INSTANCE.getServerExplorerContentService().disconnectServers(new IConnectionNode [] {connectionNode});
		        }
		        catch (ServerNotFoundException e)
		        {
		        }
    		}
		});
    }
}
