/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.io.IOException;
import java.sql.Connection;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;


/**
 * @author ljulien
 */
public class ServerExplorerConfiguration
{
	private static final RDBCorePlugin corePlugin = RDBCorePlugin.getDefault();
//	private static final ConnectionManager connectionManager = corePlugin.getConnectionManager();
	
	private static final String ERROR_CONNECTION = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.MESSAGE"); //$NON-NLS-1$
	private static final String ERROR_CONN_TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.TITLE"); //$NON-NLS-1$
	private static final String ERROR_MESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.ERROR.MESSAGE"); //$NON-NLS-1$
	private static final String USER_NAME = "user";//$NON-NLS-1$
	private static final String PASSWORD = "password";//$NON-NLS-1$
	
	private UserNotLoggedException userException;
    private Connection userConnection = null;
    private Exception connectException = null;
	
	/**
	 * Will reidentify the user
	 */
	private void getLoginInformation (final IConnectionNode server, final ConnectionInfo info, final String userName) throws UserNotLoggedException
	{
        userException = null;
//        Display.getDefault().asyncExec(new Runnable ()
//        {
//            public void run()
//            {
//                UserIdentification idDialog = new UserIdentification (userName);
//                if (idDialog.open() == Window.OK)
//                {
//                    String us = idDialog.getUserNameInformation();
//                    String pa = idDialog.getPasswordInformation();
//                    info.getProperties().setProperty(USER_NAME, us == null ? "" : us); //$NON-NLS-1$
//                    info.getProperties().setProperty(PASSWORD, pa == null ? "" : pa); //$NON-NLS-1$
//                    
//                        try
//                        {
//                            BusyIndicator.showWhile(Display.getCurrent(), new Runnable ()
//                            {
//                                public void run ()
//                                {
//                                    try
//                                    {
//                                        userConnection = info.connect();
//                                    }
//                                    catch (Exception e)
//                                    {
//                                        connectException = e;
//                                    }
//                                }
//                            });
//                            if (userConnection == null)
//                            {
//                                throw new Exception(connectException);
//                            }
//                            info.setSharedConnection(userConnection);
//                            new DatabaseProviderHelper().setDatabase(userConnection, info, info.getDatabaseName());
//                            info.saveConnectionInfo();
//                            //IServicesManager.INSTANCE.getServerExplorerContentService().updateSelection(new StructuredSelection (server));
//                        }
//                        catch (Exception e)
//                        {
//                            String message = MessageFormat.format(ERROR_CONNECTION, new String [] {e.getMessage()});
//                            if (MessageDialog.openQuestion(Display.getCurrent().getActiveShell(), ERROR_CONN_TITLE, message))
//                            {
//                                WorkOffline offline = new WorkOffline ();
//                                offline.selectionChanged(null, new StructuredSelection (server));
//                                offline.run(null);
//                            }
//                            else
//                            {
//                                userException = new UserNotLoggedException ();
//                            }
//                        }
//                }
//                else 
//                {
//                    userException = new UserNotLoggedException ();
//                }
//            }
//        });
        if (userException != null)
        {
            throw userException;
        }
    }
	
	/**
	 * Will save existing configurations available in the server Explorer
	 * @param connectionInfo - The connection info to save
	 * @param definition - Will be used to store product and version
	 * @param databases - The databases to store 
	 * @param serverNode - The server node
	 * @throws IOException 
	 */
	public void save (ConnectionInfo connectionInfo)
			throws IOException
	{
//	    connectionInfo.saveConnectionInfo();
	}

	/**
	 * Will remove the Configuration file for this server
	 * @param server
	 */
	public void deleteServer (IConnectionNode serverNode)
	{
//	    ConnectionInfo info = corePlugin.getConnectionManager().getConnectionInfo(serverNode.getName());
//	    if (info != null)
//	    {
//	        corePlugin.getConnectionManager().removeConnectionInfo(serverNode.getName());
//	    }
   	}
	
	public ConnectionInfo restoreConnectionInfo (IConnectionNode server, ConnectionInfo connectionInfo)
	{
        try
        {
            Database database = connectionInfo.getSharedDatabase();
            if (database == null)
            {
                getLoginInformation (server, connectionInfo, connectionInfo.getUserName());
            }
            return connectionInfo;
        }
        catch (UserNotLoggedException e)
        {
            return null;
        }
	}
	
	/**
	 * @return The list of previously created Connections
	 */
	public ConnectionInfo [] getRestoredConnections ()
	{	    
	//    return corePlugin.getConnectionManager().getAllNamedConnectionInfo();
	return null;
	}
	
	/**
	 * @author ljulien
	 */
	private class UserNotLoggedException extends Exception
	{

		/**
		 * Comment for <code>serialVersionUID</code>
		 */
		private static final long serialVersionUID = -5743507206244947582L;
	}
	
	/**
	 * @author ljulien
	 */
	private class ConnectionNotEstablishedException extends Exception
	{
		/**
		 * Comment for <code>serialVersionUID</code>
		 */
		private static final long serialVersionUID = 6480464713778981637L;

		public ConnectionNotEstablishedException (Throwable e)
		{
			super (e);
		}
	}
}
