/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.db.derby;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.derby.DerbyPlugin;
import org.eclipse.datatools.connectivity.db.derby.Messages;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DerbyEmbeddedDBPropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider {
    private static final String EMPTY_STRING = new String();
    private Text mDatabaseNameText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Text mURLText;
    private Button mSaveDBPWDCheckbox;
    private Button mCreateDBCheckbox;
    private Button mUpgradeDBCheckbox;
    private Text mDBFilePathText;
    private Button mBrowseFilePathButton;
    final DriverListCombo combo = new DriverListCombo();
    private DelimitedStringList mDBConnProps;
    private DriverInstance mDriverInstance;
    private String mDriverCategory;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DerbyPlugin.getDefault().getBundle().getSymbolicName());

    public DerbyEmbeddedDBPropertyPage() {
        this.noDefaultAndApplyButton();
        this.setDriverCategory("org.eclipse.datatools.connectivity.db.derby.driverCategory");
        this.combo.setFilter("templateIDStartsWith = org.eclipse.datatools.connectivity.db.derby,templateIDEndsWith = genericDriverTemplate");
    }

    protected void createCustomContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.0"));
        Composite textAndBrowseComposite = new Composite(content, 0);
        GridLayout subCompositeLayout = new GridLayout(2, false);
        subCompositeLayout.marginLeft = -5;
        subCompositeLayout.marginRight = -5;
        subCompositeLayout.marginTop = -5;
        subCompositeLayout.marginBottom = -5;
        textAndBrowseComposite.setLayout((Layout)subCompositeLayout);
        textAndBrowseComposite.setLayoutData((Object)new GridData(768));
        this.mDBFilePathText = new Text(textAndBrowseComposite, 2048);
        this.mDBFilePathText.setLayoutData((Object)new GridData(768));
        this.mBrowseFilePathButton = new Button(textAndBrowseComposite, 8);
        this.mBrowseFilePathButton.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.1"));
        this.mBrowseFilePathButton.setLayoutData((Object)new GridData(128));
        this.mURLText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mDBUIDText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mCreateDBCheckbox = new Button(content, 32);
        this.mCreateDBCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.2"));
        this.mCreateDBCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mUpgradeDBCheckbox = new Button(content, 32);
        this.mUpgradeDBCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.3"));
        this.mUpgradeDBCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                DerbyEmbeddedDBPropertyPage.this.setErrorMessage(null);
                if (DerbyEmbeddedDBPropertyPage.this.mDBConnProps.getWarning() != null) {
                    DerbyEmbeddedDBPropertyPage.this.setErrorMessage(DerbyEmbeddedDBPropertyPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String oldPassword;
                String password;
                String oldUsername;
                DerbyEmbeddedDBPropertyPage.this.mDriverInstance = DerbyEmbeddedDBPropertyPage.this.combo.getSelectedDriverInstance();
                DerbyEmbeddedDBPropertyPage.this.setErrorMessage(null);
                if (DerbyEmbeddedDBPropertyPage.this.combo.getErrorMessage() != null) {
                    DerbyEmbeddedDBPropertyPage.this.setErrorMessage(DerbyEmbeddedDBPropertyPage.this.combo.getErrorMessage());
                } else {
                    DerbyEmbeddedDBPropertyPage.this.mURLText.setText(DerbyEmbeddedDBPropertyPage.this.getDriverURL());
                }
                String username = DerbyEmbeddedDBPropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                if ((oldUsername = DerbyEmbeddedDBPropertyPage.this.mDBUIDText.getText()) == null || oldUsername.trim().length() == 0) {
                    oldUsername = new String();
                }
                if (oldUsername.length() == 0) {
                    DerbyEmbeddedDBPropertyPage.this.mDBUIDText.setText(username);
                }
                if ((password = DerbyEmbeddedDBPropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password")) == null || password.trim().length() == 0) {
                    password = new String();
                }
                if ((oldPassword = DerbyEmbeddedDBPropertyPage.this.mDBPWDText.getText()) == null || oldPassword.trim().length() == 0) {
                    oldPassword = new String();
                }
                if (oldPassword.length() == 0) {
                    DerbyEmbeddedDBPropertyPage.this.mDBPWDText.setText(password);
                }
            }
        });
        this.initControls();
        this.mDBFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DerbyEmbeddedDBPropertyPage.this.updateURLFromProps();
            }
        });
        this.mCreateDBCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.updateURLFromProps();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.updateURLFromProps();
            }
        });
        this.mUpgradeDBCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.updateURLFromProps();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.updateURLFromProps();
            }
        });
        this.mBrowseFilePathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.browseForDBFolder();
            }

            public void widgetSelected(SelectionEvent e) {
                DerbyEmbeddedDBPropertyPage.this.browseForDBFolder();
            }
        });
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        String driverID = EMPTY_STRING;
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance instance = this.combo.getSelectedDriverInstance();
            driverID = instance.getId();
        }
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.mDBConnProps.getSelection());
        props.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.vendor"));
        props.setProperty("org.eclipse.datatools.connectivity.db.version", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.version"));
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.driverClass"));
        props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.mDatabaseNameText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.mDBPWDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.mDBUIDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", this.mURLText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.mSaveDBPWDCheckbox.getSelection()));
        return props;
    }

    private void initControls() {
        String urlText;
        String databaseUid;
        String databasePwd;
        String databaseName;
        String connectionProps;
        IConnectionProfile profile = this.getConnectionProfile();
        String driverID = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverID != null) {
            this.combo.setSelectionToID(driverID);
        }
        if ((connectionProps = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null) {
            this.mDBConnProps.setSelection(connectionProps);
        }
        if ((databaseName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName")) != null) {
            this.mDatabaseNameText.setText(databaseName);
        }
        if ((databasePwd = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.mDBPWDText.setText(databasePwd);
        }
        if ((databaseUid = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.mDBUIDText.setText(databaseUid);
        }
        if ((urlText = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL")) != null) {
            this.mURLText.setText(urlText);
            this.mURLText.setEnabled(false);
        }
        this.mSaveDBPWDCheckbox.setSelection(Boolean.valueOf(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.savePWD", Boolean.FALSE.toString())).booleanValue());
        this.updatePropsFromURL();
        this.setErrorMessage(null);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
    }

    private void browseForDBFolder() {
        String selectedDirectory;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.FileDialog.title.filebrowse"));
        dialog.setMessage(Messages.getString("DerbyEmbeddedDBProfileDetailsWizardPage.FileDialog.msg.filebrowse"));
        String dirName = this.mDBFilePathText.getText();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.mDBFilePathText.setText(selectedDirectory);
        }
    }

    private void updatePropsFromURL() {
        if (this.mDBFilePathText != null && this.mURLText != null && this.mCreateDBCheckbox != null && this.mUpgradeDBCheckbox != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                String filepath = chunks2[2];
                if (chunks2.length > 3) {
                    filepath = filepath + ":" + chunks2[3];
                }
                this.mDBFilePathText.setText(filepath);
            }
            if (chunks.length > 1) {
                for (int i = 1; i < chunks.length; ++i) {
                    if (chunks[i].startsWith("create=")) {
                        this.mCreateDBCheckbox.setSelection(true);
                        continue;
                    }
                    if (!chunks[i].startsWith("upgrade=")) continue;
                    this.mUpgradeDBCheckbox.setSelection(true);
                }
            }
        }
    }

    private void updateURLFromProps() {
        if (this.mDBFilePathText != null && this.mURLText != null && this.mCreateDBCheckbox != null && this.mUpgradeDBCheckbox != null) {
            String[] chunks2;
            String url = this.mURLText.getText();
            String filePath = this.mDBFilePathText.getText();
            boolean createDB = this.mCreateDBCheckbox.getSelection();
            boolean upgradeDB = this.mUpgradeDBCheckbox.getSelection();
            String[] chunks = this.parseString(url, ";");
            if (chunks.length > 0 && (chunks2 = this.parseString(chunks[0], ":")).length > 2) {
                url = chunks2[0] + ":" + chunks2[1] + ":" + filePath;
                if (createDB) {
                    url = url + ";" + "create=true";
                }
                if (upgradeDB) {
                    url = url + ";" + "upgrade=true";
                }
                this.mURLText.setText(url);
            }
        }
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public String getDriverURL() {
        return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return super.isValid();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_CP_PROPERTY_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return contents;
    }
}

