/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.toolkit;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class StackDumpOnTimeoutRule
implements TestRule {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(1L);
    private Duration timeoutDuration;

    public StackDumpOnTimeoutRule() {
        this(DEFAULT_TIMEOUT);
    }

    public StackDumpOnTimeoutRule(Duration timeoutDuration) {
        this.timeoutDuration = (Duration)Preconditions.checkNotNull((Object)timeoutDuration, (Object)"Must specify a timeout duration");
        Preconditions.checkArgument((timeoutDuration.toMillis() > 100L ? 1 : 0) != 0, (Object)"Timeout must be > 100ms");
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Timer timer = new Timer(true);
                try {
                    timer.schedule(StackDumpOnTimeoutRule.this.createDumpStackTraceTask(), StackDumpOnTimeoutRule.this.timeoutDuration.toMillis(), StackDumpOnTimeoutRule.this.timeoutDuration.toMillis());
                    base.evaluate();
                }
                finally {
                    timer.cancel();
                }
            }
        };
    }

    private TimerTask createDumpStackTraceTask() {
        return new TimerTask(){

            @Override
            public void run() {
                StackDumpOnTimeoutRule.this.dumpStackTrace(System.out);
            }
        };
    }

    private void dumpStackTrace(PrintStream writer) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        writer.println();
        writer.println("***********");
        writer.println("All threads complete stack trace:");
        writer.println();
        for (ThreadInfo info : infos) {
            writer.println(MessageFormat.format("Thread id {0} name {1}", info.getThreadId(), info.getThreadName()));
            for (StackTraceElement stackElement : info.getStackTrace()) {
                writer.print("\tat ");
                writer.println(stackElement);
            }
        }
    }
}

