/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.toolkit;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.time.Duration;
import org.eclipse.mylyn.wikitext.toolkit.TimeoutActionRule;

public class StackDumpOnTimeoutRule
extends TimeoutActionRule {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(1L);

    public StackDumpOnTimeoutRule() {
        this(DEFAULT_TIMEOUT);
    }

    public StackDumpOnTimeoutRule(Duration timeoutDuration) {
        super(timeoutDuration);
    }

    @Override
    protected void performAction() {
        this.dumpStackTrace(System.out);
    }

    private void dumpStackTrace(PrintStream writer) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        writer.println();
        writer.println("***********");
        writer.println("All threads complete stack trace:");
        writer.println();
        for (ThreadInfo info : infos) {
            writer.println(MessageFormat.format("Thread id {0} name {1}", info.getThreadId(), info.getThreadName()));
            for (StackTraceElement stackElement : info.getStackTrace()) {
                writer.print("\tat ");
                writer.println(stackElement);
            }
        }
    }
}

