/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.ant.internal.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.mylyn.wikitext.ant.MarkupTask;
import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.PageMapping;
import org.eclipse.mylyn.wikitext.mediawiki.WikiTemplateResolver;
import org.eclipse.mylyn.wikitext.mediawiki.ant.internal.tasks.ConfigurationException;
import org.eclipse.mylyn.wikitext.mediawiki.ant.internal.tasks.MediaWikiApiImageFetchingStrategy;
import org.eclipse.mylyn.wikitext.mediawiki.ant.internal.tasks.Messages;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.splitter.DefaultSplittingStrategy;
import org.eclipse.mylyn.wikitext.splitter.NoSplittingStrategy;
import org.eclipse.mylyn.wikitext.splitter.SplitOutlineItem;
import org.eclipse.mylyn.wikitext.splitter.SplittingHtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.splitter.SplittingMarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.splitter.SplittingOutlineParser;
import org.eclipse.mylyn.wikitext.splitter.SplittingStrategy;
import org.eclipse.mylyn.wikitext.validation.StandaloneMarkupValidator;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;

public class WikiToDocTask
extends MarkupTask {
    protected String htmlFilenameFormat = "$1.html";
    private String wikiBaseUrl;
    private List<Path> paths = new ArrayList<Path>();
    private File dest;
    private PageAppendum pageAppendum;
    private final List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();
    protected String linkRel;
    protected boolean multipleOutputFiles = true;
    protected boolean formatOutput = false;
    protected boolean navigationImages = true;
    protected String prependImagePrefix = "images";
    private final boolean useInlineCssStyles = true;
    private final boolean suppressBuiltInCssStyles = false;
    private String defaultAbsoluteLinkTarget;
    private final boolean xhtmlStrict = false;
    private final boolean emitDoctype = true;
    private final String htmlDoctype;
    private String helpPrefix;
    private boolean fetchImages = true;
    private File tocFile;
    private String title;
    private boolean generateUnifiedToc = true;
    private String templateExcludes;
    private boolean titleParameter;
    private static final Pattern PAGE_NAME_PATTERN = Pattern.compile("([^#]*)(?:#(.*))?");

    public WikiToDocTask() {
        this.htmlDoctype = null;
    }

    public void execute() throws ConfigurationException {
        if (this.dest == null) {
            throw new ConfigurationException(Messages.getString("WikiToDocTask_specify_dest"));
        }
        if (this.wikiBaseUrl == null) {
            throw new ConfigurationException(Messages.getString("WikiToDocTask_specify_wikiBaseUrl"));
        }
        if (this.paths.isEmpty()) {
            throw new ConfigurationException(Messages.getString("WikiToDocTask_specify_paths"));
        }
        if (this.getInternalLinkPattern() == null) {
            this.setInternalLinkPattern(this.computeDefaultInternalLinkPattern());
        }
        HashSet<String> pathNames = new HashSet<String>();
        for (Path path : this.paths) {
            if (path.name == null) {
                throw new ConfigurationException(Messages.getString("WikiToDocTask_path_must_have_name"));
            }
            if (path.name != null && !pathNames.add(path.name)) {
                throw new ConfigurationException(MessageFormat.format(Messages.getString("WikiToDocTask_path_name_must_be_unique"), path.name));
            }
            if (path.includeInUnifiedToc || path.getTocParentName() == null) continue;
            throw new ConfigurationException(MessageFormat.format(Messages.getString("WikiToDocTask_tocParentName_not_in_unified_toc"), path.name));
        }
        if (this.generateUnifiedToc) {
            for (Path path : this.paths) {
                if (path.getTocParentName() == null || pathNames.contains(path.getTocParentName())) continue;
                throw new ConfigurationException(MessageFormat.format(Messages.getString("WikiToDocTask_unknown_tocParentName"), path.getTocParentName()));
            }
        }
        MediaWikiLanguage markupLanguage = (MediaWikiLanguage)this.createMarkupLanguage();
        WikiTemplateResolver templateResolver = new WikiTemplateResolver();
        templateResolver.setWikiBaseUrl(this.wikiBaseUrl);
        markupLanguage.getTemplateProviders().add(templateResolver);
        markupLanguage.setTemplateExcludes(this.templateExcludes);
        for (Stylesheet stylesheet : this.stylesheets) {
            if (stylesheet.url == null && stylesheet.file == null) {
                throw new BuildException(Messages.getString("WikiToDocTask_stylesheet_file_or_url"));
            }
            if (stylesheet.url != null && stylesheet.file != null) {
                throw new BuildException(Messages.getString("WikiToDocTask_stylesheet_not_both"));
            }
            if (stylesheet.file == null) continue;
            if (!stylesheet.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_stylesheet_file_not_exist"), stylesheet.file));
            }
            if (!stylesheet.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_stylesheet_file_not_file"), stylesheet.file));
            }
            if (stylesheet.file.canRead()) continue;
            throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_stylesheet_file_cannot_read"), stylesheet.file));
        }
        if (!this.dest.exists() && !this.dest.mkdirs()) {
            throw new BuildException(MessageFormat.format("Cannot create dest folder: {0}", this.dest.getAbsolutePath()));
        }
        if (this.tocFile == null) {
            this.tocFile = new File(this.dest, "toc.xml");
        }
        HashMap<String, String> pathNameToContent = new HashMap<String, String>();
        HashMap<String, SplitOutlineItem> pathNameToOutline = new HashMap<String, SplitOutlineItem>();
        for (Path path : this.paths) {
            this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_fetching_content_for_page"), path.name), 3);
            URL pathUrl = this.computeRawUrl(path.name);
            try {
                Reader input = this.createInputReader(pathUrl);
                try {
                    String content = this.readFully(input);
                    content = this.preprocessMarkup(path, content);
                    pathNameToContent.put(path.name, content);
                    File targetFile = this.computeHtmlOutputFile(path);
                    SplitOutlineItem outline = this.computeOutline(path, (MarkupLanguage)markupLanguage, targetFile, content);
                    outline.setResourcePath(targetFile.getAbsolutePath());
                    pathNameToOutline.put(path.name, outline);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                String message = MessageFormat.format("Cannot read from {0}: {1}", pathUrl, e.getMessage());
                throw new BuildException(message, (Throwable)e);
            }
        }
        for (Path path : this.paths) {
            this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_processing_page"), path.name), 4);
            String markupContent = (String)pathNameToContent.get(path.name);
            if (this.isValidate()) {
                this.performValidation((MarkupLanguage)markupLanguage, path, markupContent);
            }
            Set<String> imageFilenames = null;
            if (!this.fetchImages) {
                this.getProject().log(Messages.getString("WikiToDocTask_skipping_images"), 1);
            } else {
                imageFilenames = this.fetchImages((MarkupLanguage)markupLanguage, path);
            }
            this.markupToDoc((MarkupLanguage)markupLanguage, path, markupContent, pathNameToOutline, imageFilenames);
            if (!path.isGenerateToc()) continue;
            this.createToc(path, (OutlineItem)pathNameToOutline.get(path.name));
        }
        if (this.generateUnifiedToc) {
            this.createToc(this.paths, pathNameToOutline);
        }
    }

    protected Reader createInputReader(URL pathUrl) throws IOException {
        return new InputStreamReader((InputStream)new BufferedInputStream(pathUrl.openStream()), StandardCharsets.UTF_8);
    }

    protected void performValidation(MarkupLanguage markupLanguage, Path path, String markupContent) {
        this.getProject().log(MessageFormat.format("Validating {0}", path.name), 3);
        StandaloneMarkupValidator markupValidator = StandaloneMarkupValidator.getValidator((String)markupLanguage.getName());
        List problems = markupValidator.validate(markupContent);
        int errorCount = 0;
        int warningCount = 0;
        for (ValidationProblem problem : problems) {
            int messageLevel = 0;
            if (problem.getSeverity() == ValidationProblem.Severity.ERROR) {
                ++errorCount;
            } else if (problem.getSeverity() == ValidationProblem.Severity.WARNING) {
                ++warningCount;
                messageLevel = 1;
            }
            this.log(String.format("%s:%s %s", path.name, problem.getOffset(), problem.getMessage()), messageLevel);
        }
        if (errorCount > 0 && this.isFailOnValidationError() || warningCount > 0 && this.isFailOnValidationWarning()) {
            throw new BuildException(MessageFormat.format("Validation failed with {0} errors and {1} warnings: {0}", errorCount, warningCount, path.name));
        }
    }

    private void createToc(final Path path, OutlineItem rootItem) {
        SplittingMarkupToEclipseToc markupToEclipseToc = new SplittingMarkupToEclipseToc(){

            protected String computeFile(OutlineItem item) {
                if (item instanceof SplitOutlineItem) {
                    return WikiToDocTask.this.computeTocRelativeFile(item, path);
                }
                return super.computeFile(item);
            }
        };
        markupToEclipseToc.setBookTitle(path.getTitle());
        markupToEclipseToc.setHtmlFile(this.computeTocRelativeFile(rootItem, path));
        String tocContents = markupToEclipseToc.createToc(rootItem);
        File tocFile = new File(this.dest, path.name.replaceAll("[^a-zA-Z0-9]", "-") + "-toc.xml");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tocFile)), StandardCharsets.UTF_8);){
            writer.write(tocContents);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Cannot write {0}: {1}", tocFile, e.getMessage());
            throw new BuildException(message, (Throwable)e);
        }
    }

    private String computeTocRelativeFile(Map<OutlineItem, Path> outlineItemToPath, OutlineItem item) {
        Path path = outlineItemToPath.get(item);
        OutlineItem pathItem = item;
        while (path == null && pathItem.getParent() != null) {
            pathItem = pathItem.getParent();
            path = outlineItemToPath.get(pathItem);
        }
        return this.computeTocRelativeFile(item, path);
    }

    private String computeTocRelativeFile(OutlineItem item, Path path) {
        String name = ((SplitOutlineItem)item).getSplitTarget();
        File pathDestDir = this.computeDestDir(path);
        File tocParentFile = this.tocFile.getParentFile();
        String prefix = this.computePrefixPath(pathDestDir, tocParentFile);
        String relativePath = prefix + '/' + name;
        relativePath = relativePath.replace('\\', '/');
        if (this.helpPrefix != null) {
            String helpPath = this.helpPrefix;
            if (!(helpPath = helpPath.replace('\\', '/')).endsWith("/")) {
                helpPath = helpPath + "/";
            }
            relativePath = helpPath + relativePath;
        }
        relativePath = relativePath.replaceAll("/{2,}", "/");
        return relativePath;
    }

    private String computePrefixPath(File destDir, File tocParentFile) {
        String prefix = destDir.getAbsolutePath().substring(tocParentFile.getAbsolutePath().length());
        if ((prefix = prefix.replace('\\', '/')).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    private void createToc(List<Path> paths, Map<String, SplitOutlineItem> pathNameToOutline) {
        SplitOutlineItem pathItem;
        this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_writing_toc"), this.tocFile), 3);
        OutlineItem rootItem = new OutlineItem(null, 0, "<root>", 0, -1, this.title == null ? this.computeTitle(paths.get(0)) : this.title);
        final HashMap<OutlineItem, Path> outlineItemToPath = new HashMap<OutlineItem, Path>();
        HashMap<String, SplitOutlineItem> nameToItem = new HashMap<String, SplitOutlineItem>();
        for (Path path : paths) {
            if (!path.includeInUnifiedToc) continue;
            pathItem = pathNameToOutline.get(path.name);
            outlineItemToPath.put((OutlineItem)pathItem, path);
            nameToItem.put(path.name, pathItem);
            if (path.getTocParentName() != null) continue;
            rootItem.getChildren().add(pathItem);
        }
        for (Path path : paths) {
            if (!path.includeInUnifiedToc || path.getTocParentName() == null) continue;
            pathItem = pathNameToOutline.get(path.name);
            if (nameToItem.containsKey(path.getTocParentName())) {
                ((OutlineItem)nameToItem.get(path.getTocParentName())).getChildren().add(pathItem);
                continue;
            }
            throw new ConfigurationException(MessageFormat.format(Messages.getString("WikiToDocTask_unknown_tocParentName"), path.getTocParentName()));
        }
        SplittingMarkupToEclipseToc markupToEclipseToc = new SplittingMarkupToEclipseToc(){

            protected String computeFile(OutlineItem item) {
                if (item instanceof SplitOutlineItem) {
                    return WikiToDocTask.this.computeTocRelativeFile(outlineItemToPath, item);
                }
                return super.computeFile(item);
            }
        };
        markupToEclipseToc.setBookTitle(rootItem.getLabel());
        markupToEclipseToc.setHtmlFile(this.computeTocRelativeFile(outlineItemToPath, (OutlineItem)rootItem.getChildren().get(0)));
        String tocContents = markupToEclipseToc.createToc(rootItem);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.tocFile)), StandardCharsets.UTF_8);){
            writer.write(tocContents);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Cannot write {0}: {1}", this.tocFile, e.getMessage());
            throw new BuildException(message, (Throwable)e);
        }
    }

    private String computeDefaultInternalLinkPattern() {
        String internalLinkPattern = this.wikiBaseUrl;
        if (!internalLinkPattern.endsWith("/")) {
            internalLinkPattern = internalLinkPattern + "/";
        }
        internalLinkPattern = this.titleParameter ? internalLinkPattern + "index.php?title={0}" : internalLinkPattern + "{0}";
        return internalLinkPattern;
    }

    protected Set<String> fetchImages(MarkupLanguage markupLanguage, Path path) {
        File dest = this.computeDestDir(path);
        if (this.prependImagePrefix != null && !(dest = new File(dest, this.prependImagePrefix)).exists() && !dest.mkdirs()) {
            throw new BuildException(MessageFormat.format("Cannot create images folder: {0}", dest.getAbsolutePath()));
        }
        this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_fetching_images_for_page"), path.name), 3);
        MediaWikiApiImageFetchingStrategy imageFetchingStrategy = this.createImageFetchingStrategy();
        imageFetchingStrategy.setTask((Task)this);
        imageFetchingStrategy.setDest(dest);
        imageFetchingStrategy.setPageName(path.name);
        try {
            imageFetchingStrategy.setUrl(new URL(this.wikiBaseUrl));
        }
        catch (MalformedURLException e) {
            throw new BuildException((Throwable)e);
        }
        return imageFetchingStrategy.fetchImages();
    }

    protected MediaWikiApiImageFetchingStrategy createImageFetchingStrategy() {
        return new MediaWikiApiImageFetchingStrategy();
    }

    private String preprocessMarkup(Path path, String content) {
        if (this.pageAppendum != null) {
            String pageAppendum = this.pageAppendum.text;
            String qualifiedUrl = this.computeQualifiedWebPageUrl(path.name);
            String appendum = pageAppendum.replace("{url}", qualifiedUrl);
            appendum = appendum.replace("{name}", path.name);
            appendum = appendum.replace("{title}", this.computeTitle(path));
            content = content + appendum;
            this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_appending_markup_to_page"), path.name, appendum), 3);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markupToDoc(MarkupLanguage markupLanguage, Path path, String markupContent, Map<String, SplitOutlineItem> pathNameToOutline, Set<String> imageFilenames) throws BuildException {
        OutputStreamWriter writer;
        File htmlOutputFile = this.computeHtmlOutputFile(path);
        File pathDir = htmlOutputFile.getParentFile();
        if (!pathDir.exists() && !pathDir.mkdirs()) {
            throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_create_dest_folder"), pathDir.getAbsolutePath()));
        }
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(htmlOutputFile)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_create_output_file"), htmlOutputFile, e.getMessage()), (Throwable)e);
        }
        try {
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer, this.formatOutput);
            for (Stylesheet stylesheet : this.stylesheets) {
                HtmlDocumentBuilder.Stylesheet builderStylesheet = this.createBuilderStylesheet(pathDir, stylesheet);
                builder.addCssStylesheet(builderStylesheet);
            }
            builder.setTitle(this.computeTitle(path));
            builder.setEmitDtd(true);
            if (this.htmlDoctype != null) {
                builder.setHtmlDtd(this.htmlDoctype);
            }
            builder.setUseInlineStyles(true);
            builder.setSuppressBuiltInStyles(false);
            builder.setLinkRel(this.linkRel);
            builder.setDefaultAbsoluteLinkTarget(this.defaultAbsoluteLinkTarget);
            builder.setPrependImagePrefix(this.prependImagePrefix);
            builder.setXhtmlStrict(false);
            MarkupLanguage markupLanguageClone = markupLanguage.clone();
            if (markupLanguageClone instanceof MediaWikiLanguage) {
                MediaWikiLanguage mediaWikiLanguage = (MediaWikiLanguage)markupLanguageClone;
                mediaWikiLanguage.setPageMapping((PageMapping)new PathPageMapping(path, this.paths, pathNameToOutline));
                if (imageFilenames != null) {
                    mediaWikiLanguage.setImageNames(imageFilenames);
                }
            }
            SplitOutlineItem item = pathNameToOutline.get(path.name);
            SplittingHtmlDocumentBuilder splittingBuilder = new SplittingHtmlDocumentBuilder();
            splittingBuilder.setRootBuilder(builder);
            splittingBuilder.setOutline(item);
            splittingBuilder.setRootFile(htmlOutputFile);
            splittingBuilder.setNavigationImages(this.navigationImages);
            splittingBuilder.setFormatting(this.formatOutput);
            splittingBuilder.setNavigationImagePath(this.computeNavigationImagePath(pathDir));
            MarkupParser parser = new MarkupParser();
            parser.setMarkupLanguage(markupLanguageClone);
            parser.setBuilder((DocumentBuilder)splittingBuilder);
            parser.parse(markupContent);
        }
        catch (Throwable throwable) {
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_write_output_file"), htmlOutputFile, e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_write_output_file"), htmlOutputFile, e.getMessage()), (Throwable)e);
        }
    }

    public HtmlDocumentBuilder.Stylesheet createBuilderStylesheet(File pathDir, Stylesheet stylesheet) {
        HtmlDocumentBuilder.Stylesheet builderStylesheet;
        if (stylesheet.url != null) {
            URI uri = URI.create(stylesheet.url);
            if (uri.isAbsolute()) {
                builderStylesheet = new HtmlDocumentBuilder.Stylesheet(stylesheet.url);
            } else {
                String relativePath = "";
                File currentDest = pathDir;
                while (!currentDest.equals(this.dest)) {
                    currentDest = currentDest.getParentFile();
                    relativePath = relativePath + "../";
                }
                builderStylesheet = new HtmlDocumentBuilder.Stylesheet(relativePath + stylesheet.url);
            }
        } else {
            builderStylesheet = new HtmlDocumentBuilder.Stylesheet(stylesheet.file);
        }
        builderStylesheet.getAttributes().putAll(stylesheet.attributes);
        return builderStylesheet;
    }

    protected String computeTitle(Path path) {
        return path.title == null ? path.name : path.title;
    }

    private String computeNavigationImagePath(File pathDir) {
        String relativePath = "";
        File currentDest = pathDir;
        while (!currentDest.equals(this.dest)) {
            currentDest = currentDest.getParentFile();
            relativePath = relativePath + "../";
        }
        return relativePath + "images";
    }

    protected SplitOutlineItem computeOutline(Path path, MarkupLanguage markupLanguage, File defaultFile, String markupContent) {
        DefaultSplittingStrategy splittingStrategy = this.multipleOutputFiles ? new DefaultSplittingStrategy() : new NoSplittingStrategy();
        SplittingOutlineParser outlineParser = new SplittingOutlineParser();
        outlineParser.setMarkupLanguage(markupLanguage);
        outlineParser.setSplittingStrategy((SplittingStrategy)splittingStrategy);
        SplitOutlineItem item = outlineParser.parse(markupContent);
        item.setSplitTarget(defaultFile.getName());
        item.setLabel(this.computeTitle(path));
        return item;
    }

    protected File computeDestDir(Path path) {
        String name = path.name;
        name.replace(' ', '_');
        return new File(this.dest, name);
    }

    public File computeHtmlOutputFile(Path path) {
        File dest = this.computeDestDir(path);
        String fileName = this.computeHtmlFilename(path.name);
        return new File(dest, fileName);
    }

    private String readFully(Reader input) throws IOException {
        int i;
        StringWriter content = new StringWriter(8192);
        while ((i = input.read()) != -1) {
            content.write(i);
        }
        return content.toString();
    }

    private URL computeRawUrl(String path) {
        try {
            String qualifiedUrl = this.wikiBaseUrl;
            if (!qualifiedUrl.endsWith("/")) {
                qualifiedUrl = qualifiedUrl + "/";
            }
            qualifiedUrl = qualifiedUrl + "index.php?title=" + URLEncoder.encode(path, "UTF-8") + "&action=raw";
            return new URL(qualifiedUrl);
        }
        catch (IOException e) {
            throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_compute_raw_url"), path, e.getMessage()), (Throwable)e);
        }
    }

    private String computeQualifiedWebPageUrl(String path) {
        String qualifiedUrl = this.wikiBaseUrl;
        if (!qualifiedUrl.endsWith("/")) {
            qualifiedUrl = qualifiedUrl + "/";
        }
        if (this.titleParameter) {
            try {
                qualifiedUrl = qualifiedUrl + "index.php?title=" + URLEncoder.encode(path, "UTF-8");
            }
            catch (IOException e) {
                throw new BuildException(MessageFormat.format(Messages.getString("WikiToDocTask_cannot_compute_url"), path, e.getMessage()), (Throwable)e);
            }
        } else {
            qualifiedUrl = qualifiedUrl + path;
        }
        return qualifiedUrl;
    }

    protected String computeHtmlFilename(String name) {
        if (name.lastIndexOf(47) != -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return this.htmlFilenameFormat.replace("$1", name.replaceAll("\\s|_", "-"));
    }

    public String getWikiBaseUrl() {
        return this.wikiBaseUrl;
    }

    public void setWikiBaseUrl(String wikiBaseUrl) {
        this.wikiBaseUrl = wikiBaseUrl;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public String getLinkRel() {
        return this.linkRel;
    }

    public void setLinkRel(String linkRel) {
        this.linkRel = linkRel;
    }

    public boolean isMultipleOutputFiles() {
        return this.multipleOutputFiles;
    }

    public void setMultipleOutputFiles(boolean multipleOutputFiles) {
        this.multipleOutputFiles = multipleOutputFiles;
    }

    public boolean isFormatOutput() {
        return this.formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    public boolean isNavigationImages() {
        return this.navigationImages;
    }

    public void setNavigationImages(boolean navigationImages) {
        this.navigationImages = navigationImages;
    }

    public String getPrependImagePrefix() {
        return this.prependImagePrefix;
    }

    public void setPrependImagePrefix(String prependImagePrefix) {
        this.prependImagePrefix = prependImagePrefix;
    }

    public String getDefaultAbsoluteLinkTarget() {
        return this.defaultAbsoluteLinkTarget;
    }

    public void setDefaultAbsoluteLinkTarget(String defaultAbsoluteLinkTarget) {
        this.defaultAbsoluteLinkTarget = defaultAbsoluteLinkTarget;
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public boolean isUseInlineCssStyles() {
        return true;
    }

    public boolean isSuppressBuiltInCssStyles() {
        return false;
    }

    public boolean isXhtmlStrict() {
        return false;
    }

    public boolean isEmitDoctype() {
        return true;
    }

    public String getHtmlDoctype() {
        return this.htmlDoctype;
    }

    public String getHelpPrefix() {
        return this.helpPrefix;
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpPrefix = helpPrefix;
    }

    public void addStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException();
        }
        this.stylesheets.add(stylesheet);
    }

    public void addPath(Path path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.paths.add(path);
    }

    protected MarkupLanguage createMarkupLanguage() throws BuildException {
        if (this.getMarkupLanguage() == null) {
            MediaWikiLanguage markupLanguage = new MediaWikiLanguage();
            if (this.getInternalLinkPattern() != null) {
                markupLanguage.setInternalLinkPattern(this.getInternalLinkPattern());
            }
            if (this.getMarkupLanguageConfiguration() != null) {
                markupLanguage.configure(this.getMarkupLanguageConfiguration());
            }
            return markupLanguage;
        }
        return super.createMarkupLanguage();
    }

    public String getHtmlFilenameFormat() {
        return this.htmlFilenameFormat;
    }

    public void setHtmlFilenameFormat(String htmlFilenameFormat) {
        this.htmlFilenameFormat = htmlFilenameFormat;
    }

    public boolean isFetchImages() {
        return this.fetchImages;
    }

    public void setFetchImages(boolean fetchImages) {
        this.fetchImages = fetchImages;
    }

    public void setPageAppendum(PageAppendum pageAppendum) {
        this.pageAppendum = pageAppendum;
    }

    public PageAppendum getPageAppendum() {
        return this.pageAppendum;
    }

    public void addPageAppendum(PageAppendum pageAppendum) {
        if (pageAppendum == null) {
            throw new IllegalArgumentException();
        }
        if (this.pageAppendum != null) {
            throw new BuildException(Messages.getString("WikiToDocTask_only_one_page_appendum"));
        }
        this.pageAppendum = pageAppendum;
    }

    public File getTocFile() {
        return this.tocFile;
    }

    public void setTocFile(File tocFile) {
        this.tocFile = tocFile;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isGenerateUnifiedToc() {
        return this.generateUnifiedToc;
    }

    public void setGenerateUnifiedToc(boolean generateUnifiedToc) {
        this.generateUnifiedToc = generateUnifiedToc;
    }

    public String getTemplateExcludes() {
        return this.templateExcludes;
    }

    public void setTemplateExcludes(String templateExcludes) {
        this.templateExcludes = templateExcludes;
    }

    public boolean isTitleParameter() {
        return this.titleParameter;
    }

    public void setTitleParameter(boolean titleParameter) {
        this.titleParameter = titleParameter;
    }

    private class PathPageMapping
    implements PageMapping {
        private final Path currentPath;
        private final Map<String, Path> nameToPath = new HashMap<String, Path>();
        private final Map<String, SplitOutlineItem> pathNameToOutline;

        private PathPageMapping(Path currentPath, List<Path> paths, Map<String, SplitOutlineItem> pathNameToOutline) {
            this.currentPath = currentPath;
            this.pathNameToOutline = pathNameToOutline;
            for (Path path : paths) {
                this.nameToPath.put(path.name.replace(' ', '_'), path);
            }
        }

        public String mapPageNameToHref(String pageName) {
            Matcher matcher = PAGE_NAME_PATTERN.matcher(pageName);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String hashId = matcher.group(2);
                if (this.currentPath.name.equals(name)) {
                    return "#" + (hashId == null ? "" : hashId);
                }
                Path path = this.nameToPath.get(name = name.replace(' ', '_'));
                if (path != null) {
                    File destDir = WikiToDocTask.this.computeDestDir(path);
                    File currentDest = WikiToDocTask.this.computeDestDir(this.currentPath);
                    String relativePath = "";
                    while (!currentDest.equals(WikiToDocTask.this.dest)) {
                        currentDest = currentDest.getParentFile();
                        relativePath = relativePath + "../";
                    }
                    String relativeDir = destDir.getAbsolutePath().substring(WikiToDocTask.this.dest.getAbsolutePath().length());
                    if (File.separatorChar == '\\') {
                        relativeDir = relativeDir.replace('\\', '/');
                    }
                    if (relativeDir.startsWith("/")) {
                        relativeDir = relativeDir.substring(1);
                    }
                    if (!(relativePath = relativePath + relativeDir).endsWith("/")) {
                        relativePath = relativePath + "/";
                    }
                    String fileName = WikiToDocTask.this.computeHtmlFilename(name);
                    if (hashId != null) {
                        SplitOutlineItem outline = this.pathNameToOutline.get(name);
                        SplitOutlineItem item = outline.getOutlineItemById(hashId);
                        if (item == null) {
                            WikiToDocTask.this.getProject().log(MessageFormat.format(Messages.getString("WikiToDocTask_missing_id_in_page_reference"), hashId, name, this.currentPath.name), 1);
                        } else {
                            fileName = item.getSplitTarget();
                        }
                        relativePath = relativePath + fileName;
                        relativePath = relativePath + '#' + hashId;
                    } else {
                        relativePath = relativePath + fileName;
                    }
                    return relativePath;
                }
            }
            return null;
        }
    }

    public static class PageAppendum {
        String text;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void addText(String text) {
            this.text = this.text == null ? text : this.text + text;
        }
    }

    public static class Stylesheet {
        private File file;
        private String url;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void addConfiguredAttribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute.getValue());
        }
    }

    public static class Attribute {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Path {
        private String title;
        private String name;
        private boolean generateToc = false;
        private boolean includeInUnifiedToc = true;
        private String tocParentName;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isGenerateToc() {
            return this.generateToc;
        }

        public void setGenerateToc(boolean generateToc) {
            this.generateToc = generateToc;
        }

        public boolean isIncludeInUnifiedToc() {
            return this.includeInUnifiedToc;
        }

        public void setIncludeInUnifiedToc(boolean includeInUnifiedToc) {
            this.includeInUnifiedToc = includeInUnifiedToc;
        }

        public String getTocParentName() {
            return this.tocParentName;
        }

        public void setTocParentName(String tocParentName) {
            this.tocParentName = tocParentName;
        }

        public String toString() {
            String s = this.name;
            if (this.tocParentName != null) {
                s = this.tocParentName + '/' + s;
            }
            return s;
        }
    }
}

