/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.maven.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;

public class FileToMarkupLanguage {
    private final Map<String, MarkupLanguage> extensionToMarkupLanguage;

    public FileToMarkupLanguage() {
        this(ServiceLocator.getInstance((ClassLoader)FileToMarkupLanguage.class.getClassLoader()).getAllMarkupLanguages());
    }

    public FileToMarkupLanguage(Set<MarkupLanguage> markupLanguages) {
        this.extensionToMarkupLanguage = this.computeExtensionToMarkupLanguage((Set)Preconditions.checkNotNull(markupLanguages));
    }

    public MarkupLanguage get(File file) {
        Preconditions.checkNotNull((Object)file);
        String extension = this.computeFileExtension(file);
        return this.extensionToMarkupLanguage.get(extension.toLowerCase());
    }

    Map<String, MarkupLanguage> computeExtensionToMarkupLanguage(Set<MarkupLanguage> markupLanguages) {
        HashMap<String, MarkupLanguage> extensionToMarkupLanguage = new HashMap<String, MarkupLanguage>();
        for (MarkupLanguage language : markupLanguages) {
            for (String extension : language.getFileExtensions()) {
                extensionToMarkupLanguage.put(extension.toLowerCase(), language);
            }
        }
        return extensionToMarkupLanguage;
    }

    String computeFileExtension(File file) {
        String name = file.getName();
        int indexOfDot = name.lastIndexOf(46);
        if (indexOfDot >= 0 && indexOfDot < name.length() - 1) {
            return name.substring(indexOfDot + 1);
        }
        return "";
    }
}

