/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.block;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.confluence.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class TableBlock
extends Block {
    private static final int LINE_PROCESSED_INDICATOR = -1;
    private static final List<Class<?>> NESTABLE_CELL_BLOCKS = ImmutableList.of(ListBlock.class);
    private static final Pattern START_PATTERN = Pattern.compile("\\s*(\\|\\|?.*$)");
    private static final Pattern END_OF_CELL_CONTENT_PATTERN = Pattern.compile("((?:(?:[^\\|\\[]*)(?:\\[[^\\]]*\\])?)*)(\\|\\|?\\s*)+?");
    private static final Pattern END_OF_ROW_PATTERN = Pattern.compile("^\\|\\|?\\s*$");
    private static final Pattern TABLE_ROW_PATTERN = Pattern.compile("\\|(\\|)?\\s*((?:(?:[^\\|\\[]*)(?:\\[[^\\]]*\\])?)*)(\\|\\|?\\s*$)?");
    private int blockLineCount = 0;
    private Matcher matcher;
    private DocumentBuilder.BlockType currentCell;
    private boolean nesting = false;
    private boolean rowStarted = false;
    private boolean multiLineCell = false;

    public int processLineContent(String line, int offset) {
        this.nesting = false;
        int finalOffset = this.processLineStart(line, offset);
        if (this.isClosed() || finalOffset == -1) {
            return this.isClosed() ? 0 : -1;
        }
        ++this.blockLineCount;
        if (this.atEndOfRow(line, finalOffset)) {
            this.ensureRowClosed();
            finalOffset = -1;
        } else {
            finalOffset = this.processCellContent(line, finalOffset);
        }
        return this.isClosed() ? 0 : this.processEndOfLine(line, finalOffset);
    }

    private int processLineStart(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, attributes);
        } else if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
        } else if (offset == 0 && this.multiLineCell) {
            offset = this.continueMultiLineCell(line, offset);
        } else if (!TABLE_ROW_PATTERN.matcher(line).find()) {
            this.setClosed(true);
        }
        return offset;
    }

    private int continueMultiLineCell(String line, int offset) {
        String cellContent = line;
        Matcher rowMatcher = TABLE_ROW_PATTERN.matcher(line);
        if (rowMatcher.find()) {
            offset = rowMatcher.start();
            if (offset > 0) {
                cellContent = line.substring(0, offset);
                this.builder.lineBreak();
                this.emitMarkup(cellContent, 0);
            }
        } else {
            this.builder.lineBreak();
            this.emitMarkup(cellContent, 0);
            return -1;
        }
        this.ensureCellClosed();
        return offset;
    }

    private boolean atEndOfRow(String line, int lineOffset) {
        String restOfLine = line.substring(lineOffset);
        return END_OF_ROW_PATTERN.matcher(restOfLine).find();
    }

    private int processCellContent(String line, int offset) {
        int cellsOffset = 0;
        String restOfline = offset == 0 ? line : line.substring(offset);
        Matcher rowMatcher = TABLE_ROW_PATTERN.matcher(restOfline);
        if (rowMatcher.find()) {
            do {
                this.ensureCellClosed();
                cellsOffset = this.startNextCell(rowMatcher);
                String cellContent = rowMatcher.group(2);
                this.nesting = this.isNestableCellContent(cellContent);
                if (this.nesting) continue;
                this.emitMarkup(cellContent, offset + cellsOffset);
                cellsOffset = rowMatcher.end(2);
            } while (!this.nesting && rowMatcher.find());
        } else {
            this.setClosed(true);
        }
        return offset + cellsOffset;
    }

    private int startNextCell(Matcher rowMatcher) {
        this.ensureRowStarted();
        String headerIndicator = rowMatcher.group(1);
        boolean header = "|".equals(headerIndicator);
        this.currentCell = header ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL;
        this.builder.beginBlock(this.currentCell, new Attributes());
        return rowMatcher.start(2);
    }

    private boolean isNestableCellContent(String cellContent) {
        return NESTABLE_CELL_BLOCKS.contains(this.getConfluenceLanguage().startBlock(cellContent, 0).getClass());
    }

    private void emitMarkup(String text, int lineOffset) {
        this.getConfluenceLanguage().emitMarkupLine(this.getParser(), this.state, lineOffset, CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)text), 0);
    }

    private ConfluenceLanguage getConfluenceLanguage() {
        return (ConfluenceLanguage)this.getMarkupLanguage();
    }

    private int processEndOfLine(String line, int offset) {
        if (offset != -1 && !this.nesting) {
            if (this.atEndOfRow(line, offset)) {
                this.ensureRowClosed();
                return -1;
            }
            this.multiLineCell = true;
        }
        return offset >= line.length() ? -1 : offset;
    }

    public boolean beginNesting() {
        return this.nesting;
    }

    public int findCloseOffset(String line, int lineOffset) {
        Matcher endMatcher = END_OF_CELL_CONTENT_PATTERN.matcher(line);
        if (lineOffset != 0) {
            endMatcher.region(lineOffset, line.length());
        }
        if (endMatcher.find()) {
            return endMatcher.start(2);
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = START_PATTERN.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    private void ensureRowStarted() {
        if (!this.rowStarted) {
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
            this.rowStarted = true;
        }
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.ensureRowClosed();
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    private void ensureRowClosed() {
        this.ensureCellClosed();
        if (this.rowStarted) {
            this.builder.endBlock();
            this.rowStarted = false;
        }
    }

    private void ensureCellClosed() {
        if (this.currentCell != null) {
            this.builder.endBlock();
            this.currentCell = null;
            this.multiLineCell = false;
        }
    }
}

