/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;

class InlinesSubstitution {
    private final Inline first;
    private final Inline last;
    private final List<Inline> substitution;

    public InlinesSubstitution(Inline first, Inline last, List<Inline> substitution) {
        this.first = (Inline)Preconditions.checkNotNull((Object)first);
        this.last = (Inline)Preconditions.checkNotNull((Object)last);
        this.substitution = ImmutableList.copyOf(substitution);
    }

    public List<Inline> apply(List<Inline> inlines) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean inReplacementSegment = false;
        for (Inline inline : inlines) {
            if (inline == this.first) {
                inReplacementSegment = true;
                builder.addAll(this.substitution);
            }
            if (!inReplacementSegment) {
                builder.add((Object)inline);
            }
            if (!inReplacementSegment || inline != this.last) continue;
            inReplacementSegment = false;
        }
        return builder.build();
    }
}

