/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HtmlTag;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class HtmlTagSpan
extends SourceSpan {
    private static final String ATTRIBUTE_VALUE_QUOTED = "\"[^\"]*\"";
    private static final String ATTRIBUTE_VALUE_SINGLEQUOTED = "'[^']*'";
    private static final String ATTRIBUTE_VALUE_UNQUOTED = "[^\"'<>=]+";
    private static final String ATTRIBUTE_VALUE = "(?:\"[^\"]*\"|'[^']*'|[^\"'<>=]+)";
    private static final String ATTRIBUTE_NAME = "[a-zA-Z_][a-zA-Z0-9_:.-]*";
    private static final String ATTRIBUTE = "(?:\\s+[a-zA-Z_][a-zA-Z0-9_:.-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\"'<>=]+))?)";
    private static final String TAG = "<[a-zA-Z_][a-zA-Z_:0-9]*(?:\\s+[a-zA-Z_][a-zA-Z0-9_:.-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\"'<>=]+))?)*\\s*/?>";
    private static final String CLOSE_TAG = "</[a-zA-Z_][a-zA-Z_:0-9-]*\\s*>";
    private static final String COMMENT = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
    private static final String PROCESSING_INSTRUCTION = "<\\?.*?\\?>";
    private static final String XML_DECLARATION = "<![A-Z]+(\\s+[^>]*)*>";
    private static final String CDATA = "<!\\[CDATA\\[.*?\\]\\]>";
    private static final String REGEX_TAG = "(<[a-zA-Z_][a-zA-Z_:0-9]*(?:\\s+[a-zA-Z_][a-zA-Z0-9_:.-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\"'<>=]+))?)*\\s*/?>|</[a-zA-Z_][a-zA-Z_:0-9-]*\\s*>|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|<\\?.*?\\?>|<![A-Z]+(\\s+[^>]*)*>|<!\\[CDATA\\[.*?\\]\\]>).*";
    private final Pattern tagPattern = Pattern.compile("(<[a-zA-Z_][a-zA-Z_:0-9]*(?:\\s+[a-zA-Z_][a-zA-Z0-9_:.-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^\"'<>=]+))?)*\\s*/?>|</[a-zA-Z_][a-zA-Z_:0-9-]*\\s*>|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|<\\?.*?\\?>|<![A-Z]+(\\s+[^>]*)*>|<!\\[CDATA\\[.*?\\]\\]>).*", 32);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '<' && (matcher = cursor.matcher(this.tagPattern)).matches()) {
            return Optional.of((Object)new HtmlTag(cursor.getLineAtOffset(), cursor.getOffset(), matcher.group(1)));
        }
        return Optional.absent();
    }
}

