/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;

public class SetextHeaderBlock
extends SourceBlock {
    private final Pattern indentPattern = Pattern.compile("\\s{0,3}\\S.*");
    private final Pattern setextUnderlinePattern = Pattern.compile("\\s{0,3}((-|=)+)\\s*");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Line currentLine = lineSequence.getCurrentLine();
        Line nextLine = lineSequence.getNextLine();
        Matcher matcher = this.setextUnderlinePattern.matcher(nextLine.getText());
        Preconditions.checkState((boolean)matcher.matches());
        lineSequence.advance();
        builder.setLocator(currentLine.toLocator());
        int headingLevel = this.headingLevel(matcher);
        TextSegment textSegment = new TextSegment(Collections.singletonList(currentLine));
        HeadingAttributes attributes = new HeadingAttributes();
        InlineParser inlineParser = context.getInlineParser();
        String headingText = inlineParser.toStringContent(context, textSegment);
        attributes.setId(context.generateHeadingId(headingLevel, headingText));
        builder.beginHeading(headingLevel, (Attributes)attributes);
        inlineParser.emit(context, builder, textSegment);
        builder.endHeading();
        lineSequence.advance();
    }

    private int headingLevel(Matcher matcher) {
        return matcher.group(1).charAt(0) == '=' ? 1 : 2;
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        Line nextLine = lineSequence.getNextLine();
        return line != null && nextLine != null && this.indentPattern.matcher(line.getText()).matches() && this.setextUnderlinePattern.matcher(nextLine.getText()).matches();
    }
}

