/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Emphasis;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithText;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlinesSubstitution;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Strong;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

class PotentialEmphasisDelimiter
extends InlineWithText {
    private final boolean canOpen;
    private final boolean canClose;

    public PotentialEmphasisDelimiter(Line line, int offset, int length, String text, boolean canOpen, boolean canClose) {
        super(line, offset, length, text);
        this.canOpen = canOpen;
        this.canClose = canClose;
    }

    @Override
    public void emit(DocumentBuilder builder) {
        builder.characters(this.text);
    }

    @Override
    Optional<InlinesSubstitution> secondPass(List<Inline> inlines) {
        if (!this.canClose) {
            return Optional.empty();
        }
        int indexOfThis = inlines.indexOf(this);
        Optional<PotentialEmphasisDelimiter> opener = this.previousOpener(inlines, indexOfThis);
        if (opener.isPresent()) {
            PotentialEmphasisDelimiter openingDelimiter = opener.get();
            int delimiterSize = this.delimiterSize(openingDelimiter);
            int indexOfOpeningDelimiter = inlines.indexOf(openingDelimiter);
            List<Inline> contents = InlineParser.secondPass(inlines.subList(indexOfOpeningDelimiter + 1, indexOfThis));
            int spanOffset = openingDelimiter.getOffset();
            int spanLength = this.getOffset() + this.getLength() - openingDelimiter.getOffset();
            Inline emphasis = this.createEmphasis(openingDelimiter.getLine(), spanOffset, spanLength, delimiterSize, contents);
            ImmutableList.Builder substitutionInlines = ImmutableList.builder();
            if (delimiterSize < openingDelimiter.getLength()) {
                substitutionInlines.add((Object)this.createPotentialOpeningDelimiter(openingDelimiter, delimiterSize));
            }
            substitutionInlines.add((Object)emphasis);
            if (delimiterSize < this.getLength()) {
                substitutionInlines.add((Object)this.createPotentialClosingDelimiter(delimiterSize));
            }
            return Optional.of(new InlinesSubstitution(openingDelimiter, this, (List<Inline>)substitutionInlines.build()));
        }
        return Optional.empty();
    }

    private Inline createPotentialClosingDelimiter(int delimiterSize) {
        return new PotentialEmphasisDelimiter(this.getLine(), this.getOffset() + delimiterSize, this.getLength() - delimiterSize, this.getText().substring(0 + delimiterSize, this.getText().length()), this.canOpen, this.canClose);
    }

    private Inline createEmphasis(Line line, int offset, int length, int delimiterSize, List<Inline> contents) {
        if (delimiterSize == 1) {
            return new Emphasis(line, offset, length, contents);
        }
        return new Strong(line, offset, length, contents);
    }

    private PotentialEmphasisDelimiter createPotentialOpeningDelimiter(PotentialEmphasisDelimiter openingDelimiter, int consumedSize) {
        return new PotentialEmphasisDelimiter(openingDelimiter.getLine(), openingDelimiter.getOffset(), openingDelimiter.getLength() - consumedSize, openingDelimiter.getText().substring(0, openingDelimiter.getText().length() - consumedSize), openingDelimiter.canOpen, openingDelimiter.canClose);
    }

    private int delimiterSize(PotentialEmphasisDelimiter openingDelimiter) {
        int openingLength = openingDelimiter.getLength();
        if (openingLength < 3 || this.getLength() < 3) {
            return openingLength > this.getLength() ? this.getLength() : openingLength;
        }
        return this.getLength() % 2 == 0 ? 2 : 1;
    }

    private Optional<PotentialEmphasisDelimiter> previousOpener(List<Inline> inlines, int indexOfThis) {
        char c = this.getText().charAt(0);
        for (int index = indexOfThis - 1; index >= 0; --index) {
            Inline inline = inlines.get(index);
            if (!(inline instanceof PotentialEmphasisDelimiter)) continue;
            PotentialEmphasisDelimiter previousDelimiter = (PotentialEmphasisDelimiter)inline;
            if (!previousDelimiter.canOpen || previousDelimiter.getText().charAt(0) != c) continue;
            return Optional.of(previousDelimiter);
        }
        return Optional.empty();
    }
}

