/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.CommonMark;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlocks;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.BlockWithNestedBlocks;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.EmptyBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.blocks.ParagraphBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.NoOpDocumentBuilder;

public class ListBlock
extends BlockWithNestedBlocks {
    private final Pattern bulletPattern = Pattern.compile("\\s{0,3}(([*+-])|(([0-9]{0,5})[.)]))(?:(?:\\s(\\s*)(.*))|\\s*$)");
    private final HorizontalRuleBlock horizontalRuleBlock = new HorizontalRuleBlock();

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        this.process(context, builder, lineSequence, (context1, builder1, listMode, lineSequence1) -> this.emitListItem(context1, builder1, listMode, lineSequence1));
    }

    @Override
    public void createContext(ProcessingContextBuilder contextBuilder, LineSequence lineSequence) {
        this.process(ProcessingContext.builder().build(), (DocumentBuilder)new NoOpDocumentBuilder(), lineSequence, (dummyContext, builder, listMode, lineSequence1) -> CommonMark.sourceBlocks().createContext(contextBuilder, this.listItemLineSequence(lineSequence1)));
    }

    private void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence, ListItemHandler listItemHandler) {
        builder.setLocator(lineSequence.getCurrentLine().toLocator());
        char bulletType = this.bulletType(lineSequence.getCurrentLine());
        ListAttributes listAttributes = new ListAttributes();
        listAttributes.setStart(this.listStart(lineSequence.getCurrentLine()));
        ListMode listMode = this.calculateListMode(context, lineSequence.lookAhead(), bulletType);
        builder.beginBlock(this.listBlockType(bulletType), (Attributes)listAttributes);
        while (this.currentLineIsInList(lineSequence, bulletType)) {
            builder.setLocator(lineSequence.getCurrentLine().toLocator());
            builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
            this.emitListItem(context, builder, listMode, lineSequence);
            builder.endBlock();
        }
        builder.endBlock();
    }

    private boolean currentLineIsInList(LineSequence lineSequence, char bulletType) {
        return lineSequence.getCurrentLine() != null && this.isBulletListItem(lineSequence.getCurrentLine()) && bulletType == this.bulletType(lineSequence.getCurrentLine()) && !this.horizontalRuleBlock.canStart(lineSequence);
    }

    private ListMode calculateListMode(ProcessingContext context, LineSequence lineSequence, char bulletType) {
        ListMode listMode = ListMode.TIGHT;
        while (listMode != ListMode.LOOSE && this.currentLineIsInList(lineSequence, bulletType)) {
            if (listMode == ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE) {
                listMode = ListMode.LOOSE;
                continue;
            }
            listMode = this.calculateListItemListMode(context, lineSequence);
        }
        return listMode == ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE ? ListMode.TIGHT : listMode;
    }

    private ListMode calculateListItemListMode(ProcessingContext context, LineSequence lineSequence) {
        if (this.isSingleEmptyLineListItem(lineSequence)) {
            lineSequence.advance();
            return ListMode.TIGHT;
        }
        List<SourceBlock> blocks = this.calculateListItemBlocks(context, lineSequence);
        if (blocks.isEmpty()) {
            lineSequence.advance();
            return ListMode.TIGHT;
        }
        return this.getListItemListMode(blocks, lineSequence);
    }

    private boolean isSingleEmptyLineListItem(LineSequence lineSequence) {
        LineSequence listItemLineSequence = this.listItemLineSequence(lineSequence.lookAhead());
        return listItemLineSequence.getCurrentLine().isEmpty() && listItemLineSequence.getNextLine() == null;
    }

    private ListMode getListItemListMode(List<SourceBlock> blocks, LineSequence lineSequence) {
        if (blocks.isEmpty()) {
            return ListMode.TIGHT;
        }
        for (int x = 1; x < blocks.size() - 1; ++x) {
            SourceBlock block = blocks.get(x);
            if (!(block instanceof EmptyBlock)) continue;
            return ListMode.LOOSE;
        }
        if (blocks.get(blocks.size() - 1) instanceof EmptyBlock) {
            return ListMode.TIGHT_WITH_TRAILING_EMPTY_LINE;
        }
        return ListMode.TIGHT;
    }

    private List<SourceBlock> calculateListItemBlocks(ProcessingContext context, LineSequence lineSequence) {
        SourceBlocks sourceBlocks = CommonMark.sourceBlocks();
        return sourceBlocks.calculateSourceBlocks(context, this.listItemLineSequence(lineSequence), this.listItemBlockContextPredicate());
    }

    private Predicate<SourceBlocks.BlockContext> listItemBlockContextPredicate() {
        return new Predicate<SourceBlocks.BlockContext>(){

            public boolean apply(SourceBlocks.BlockContext blockContext) {
                return blockContext.getPreviousBlock() == null || !(blockContext.getCurrentBlock() instanceof EmptyBlock) || !this.nextLineIsEmpty(blockContext.getLineSequence());
            }

            private boolean nextLineIsEmpty(LineSequence lineSequence) {
                Line nextLine = lineSequence.getNextLine();
                return nextLine != null && nextLine.isEmpty();
            }
        };
    }

    private DocumentBuilder.BlockType listBlockType(char bulletType) {
        switch (bulletType) {
            case '*': 
            case '+': 
            case '-': {
                return DocumentBuilder.BlockType.BULLETED_LIST;
            }
        }
        return DocumentBuilder.BlockType.NUMERIC_LIST;
    }

    private void emitListItem(ProcessingContext context, DocumentBuilder builder, ListMode listMode, LineSequence lineSequence) {
        List<SourceBlock> blocks = this.calculateListItemBlocks(context, lineSequence.lookAhead());
        if (blocks.isEmpty()) {
            lineSequence.advance();
            return;
        }
        LineSequence contentLineSequence = this.listItemLineSequence(lineSequence);
        if (!blocks.isEmpty() && blocks.get(0) instanceof EmptyBlock) {
            blocks.remove(0);
            while (contentLineSequence.getCurrentLine() != null && contentLineSequence.getCurrentLine().isEmpty()) {
                contentLineSequence.advance();
            }
        }
        for (SourceBlock block : blocks) {
            if (listMode == ListMode.TIGHT && block instanceof ParagraphBlock) {
                ParagraphBlock paragraphBlock = (ParagraphBlock)block;
                paragraphBlock.processInlines(context, builder, contentLineSequence, false);
                continue;
            }
            block.process(context, builder, contentLineSequence);
        }
    }

    private LineSequence listItemLineSequence(LineSequence lineSequence) {
        final int indentOffset = this.calculateLineItemIndent(lineSequence.getCurrentLine());
        LineSequence itemLinesSequence = lineSequence.with(new Predicate<Line>(){
            int firstLineNumber = -1;

            public boolean apply(Line line) {
                if (this.firstLineNumber == -1) {
                    this.firstLineNumber = line.getLineNumber();
                }
                return this.firstLineNumber == line.getLineNumber() || line.isEmpty() || ListBlock.this.isIndented(line, indentOffset);
            }
        });
        return itemLinesSequence.transform((Function<Line, Line>)((Function)line -> {
            if (line.isEmpty()) {
                return line;
            }
            int length = Math.max(line.getText().length() - indentOffset, 0);
            int offset = Math.min(indentOffset, line.getText().length());
            return line.segment(offset, length);
        }));
    }

    private boolean isIndented(Line line, int indentSize) {
        int firstNonWhitespace = CharMatcher.whitespace().negate().indexIn((CharSequence)line.getText());
        return firstNonWhitespace >= indentSize;
    }

    private int calculateLineItemIndent(Line line) {
        Matcher matcher = this.bulletPattern.matcher(line.getText());
        Preconditions.checkState((boolean)matcher.matches());
        int start = matcher.start(6);
        if (start == -1) {
            start = line.getText().length() + 1;
        } else {
            String whitespaceAfterListMarker = matcher.group(5);
            if (whitespaceAfterListMarker != null && whitespaceAfterListMarker.length() >= 4) {
                start = matcher.start(5);
            }
        }
        return start;
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && this.isBulletListItem(line);
    }

    private char bulletType(Line line) {
        Matcher matcher = this.bulletPattern.matcher(line.getText());
        Preconditions.checkState((boolean)matcher.matches());
        String text = matcher.group(1);
        return text.charAt(text.length() - 1);
    }

    private String listStart(Line line) {
        Matcher matcher = this.bulletPattern.matcher(line.getText());
        Preconditions.checkState((boolean)matcher.matches());
        String marker = matcher.group(4);
        if ("1".equals(marker)) {
            marker = null;
        }
        return marker;
    }

    private boolean isBulletListItem(Line line) {
        return this.bulletPattern.matcher(line.getText()).matches();
    }

    private static interface ListItemHandler {
        public void emitListItem(ProcessingContext var1, DocumentBuilder var2, ListMode var3, LineSequence var4);
    }

    private static enum ListMode {
        TIGHT,
        LOOSE,
        TIGHT_WITH_TRAILING_EMPTY_LINE;

    }
}

