/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.EscapedCharacter;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HardLineBreak;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class BackslashEscapeSpan
extends SourceSpan {
    private static CharMatcher ESCAPABLE = CharMatcher.anyOf((CharSequence)"!\"\\#$%&'()*+,-./:;<=>?@[]^_`{|}~");

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        char c = cursor.getChar();
        if (c == '\\' && cursor.hasNext()) {
            if (cursor.getNext() == '\n') {
                return Optional.of((Object)new HardLineBreak(cursor.getLineAtOffset(), cursor.getOffset(), 2));
            }
            if (ESCAPABLE.matches(cursor.getNext())) {
                return Optional.of((Object)new EscapedCharacter(cursor.getLineAtOffset(), cursor.getOffset(), cursor.getNext()));
            }
        }
        return Optional.absent();
    }
}

