/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.TableRowAttributes;

public class TableBlock
extends AsciiDocBlock {
    private TableFormat format;
    private String separator;
    private int cellsCount = 0;
    private List<TableCellAttributes> colsAttribute;
    private boolean hasHeader = false;
    private boolean cellBlockIsOpen = false;

    public TableBlock() {
        super(Pattern.compile("^(\\||,|:)===\\s*"));
    }

    @Override
    protected void processBlockStart() {
        String options;
        String separator;
        if (this.startDelimiter.startsWith(",")) {
            this.format = TableFormat.COMMA_SEPARATED_VALUES;
            this.hasHeader = true;
        } else if (this.startDelimiter.startsWith(":")) {
            this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
            this.hasHeader = true;
        } else {
            this.format = TableFormat.PREFIX_SEPARATED_VALUES;
            this.separator = "|";
        }
        Map<String, String> lastProperties = this.getAsciiDocState().getLastProperties(Collections.emptyList());
        this.colsAttribute = LanguageSupport.computeColumnsAttributeList(lastProperties.get("cols"));
        String formatProperty = lastProperties.get("format");
        if (formatProperty != null) {
            switch (formatProperty) {
                case "dsv": {
                    this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
                    break;
                }
                case "csv": {
                    this.format = TableFormat.COMMA_SEPARATED_VALUES;
                }
            }
        }
        if ((separator = lastProperties.get("separator")) != null) {
            this.separator = separator;
        }
        if ((options = lastProperties.get("options")) != null) {
            this.hasHeader = options.contains("header");
        }
        TableAttributes tableAttributes = new TableAttributes();
        tableAttributes.setWidth(lastProperties.get("width"));
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)tableAttributes);
    }

    private final boolean isColFormatKnown() {
        return !this.colsAttribute.isEmpty();
    }

    private final boolean isFirstRow() {
        return this.colsAttribute.isEmpty() || this.cellsCount < this.colsAttribute.size();
    }

    private final boolean isFirsCellOfTable() {
        return !this.cellBlockIsOpen;
    }

    @Override
    protected void processBlockContent(String line) {
        if (!line.trim().isEmpty()) {
            if (!this.isColFormatKnown() && !this.cellBlockIsOpen) {
                TableRowAttributes tableRowAttributes = new TableRowAttributes();
                this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
            }
            int offset = 0;
            boolean firstCellInLine = true;
            Matcher rowCellMatcher = this.createRowCellMatcher(line);
            while (offset <= line.length()) {
                boolean found = rowCellMatcher.find();
                int endOffset = found ? rowCellMatcher.start() : line.length();
                String cellContent = line.substring(offset, endOffset);
                if (offset == 0 && this.format == TableFormat.PREFIX_SEPARATED_VALUES) {
                    if (!cellContent.isEmpty()) {
                        if (this.isFirsCellOfTable()) {
                            this.handleCellContent(cellContent, offset);
                            firstCellInLine = false;
                        } else {
                            this.appendCellContent(cellContent, endOffset);
                            firstCellInLine = false;
                        }
                    }
                } else {
                    if (!this.isColFormatKnown() && firstCellInLine && !this.isFirsCellOfTable()) {
                        this.colsAttribute = LanguageSupport.createDefaultColumnsAttributeList(this.cellsCount + 1);
                    }
                    this.handleCellContent(cellContent, offset);
                    firstCellInLine = false;
                }
                offset = found ? rowCellMatcher.end() : line.length() + 1;
            }
        }
    }

    private Matcher createRowCellMatcher(String line) {
        if (this.format == TableFormat.COMMA_SEPARATED_VALUES) {
            String regex = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
            return Pattern.compile(regex).matcher(line);
        }
        String delimiter = this.getCellSeparator();
        return Pattern.compile("(?<!\\\\)" + Pattern.quote(delimiter)).matcher(line);
    }

    private String getCellSeparator() {
        switch (this.format) {
            case COMMA_SEPARATED_VALUES: {
                return ",";
            }
            case DELIMITER_SEPARATED_VALUES: {
                return ":";
            }
        }
        return this.separator;
    }

    private void handleCellContent(String fullCellContent, int positionInLine) {
        String blockContent;
        this.closeCellBlockIfNeeded();
        String cellContent = fullCellContent.trim();
        if (this.format == TableFormat.COMMA_SEPARATED_VALUES) {
            blockContent = cellContent.startsWith("\"") && cellContent.endsWith("\"") ? cellContent.substring(1, cellContent.length() - 1).replaceAll("\"\"", "\"") : cellContent;
        } else {
            String delimiter = this.getCellSeparator();
            blockContent = cellContent.replaceAll("\\\\" + Pattern.quote(delimiter), delimiter);
        }
        if (this.isColFormatKnown() && this.cellsCount % this.colsAttribute.size() == 0) {
            TableRowAttributes tableRowAttributes = new TableRowAttributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
        }
        TableCellAttributes attributes = this.colsAttribute.isEmpty() ? new TableCellAttributes() : this.colsAttribute.get(this.cellsCount % this.colsAttribute.size());
        if (this.hasHeader && this.isFirstRow()) {
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_HEADER, (Attributes)attributes);
        } else {
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, (Attributes)attributes);
        }
        this.cellBlockIsOpen = true;
        int offset = fullCellContent.indexOf(cellContent);
        this.markupLanguage.emitMarkupLine(this.parser, this.state, offset + positionInLine, blockContent, 0);
    }

    private void appendCellContent(String cellContent, int positionInLine) {
        this.markupLanguage.emitMarkupLine(this.parser, this.state, positionInLine, " " + cellContent.trim(), 0);
    }

    @Override
    protected void processBlockEnd() {
        this.closeCellBlockIfNeeded();
        if (!this.isColFormatKnown() && this.cellsCount > 0 || this.isColFormatKnown() && this.cellsCount % this.colsAttribute.size() != 0) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private void closeCellBlockIfNeeded() {
        if (this.cellBlockIsOpen) {
            this.builder.endBlock();
            this.cellBlockIsOpen = false;
            ++this.cellsCount;
            if (!this.colsAttribute.isEmpty() && this.cellsCount % this.colsAttribute.size() == 0) {
                this.builder.endBlock();
            }
        }
    }

    private static enum TableFormat {
        PREFIX_SEPARATED_VALUES,
        DELIMITER_SEPARATED_VALUES,
        COMMA_SEPARATED_VALUES;

    }
}

