/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.subscriptions;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;

public interface UaSubscription {
    public UInteger getSubscriptionId();

    public double getRequestedPublishingInterval();

    public double getRevisedPublishingInterval();

    public UInteger getRequestedLifetimeCount();

    public UInteger getRevisedLifetimeCount();

    public UInteger getRequestedMaxKeepAliveCount();

    public UInteger getRevisedMaxKeepAliveCount();

    public UInteger getMaxNotificationsPerPublish();

    public boolean isPublishingEnabled();

    public UByte getPriority();

    public ImmutableList<UaMonitoredItem> getMonitoredItems();

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2);

    default public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate, BiConsumer<UaMonitoredItem, Integer> itemCreationCallback) {
        return this.createMonitoredItems(timestampsToReturn, itemsToCreate, (SerializationContext serializationContext, UaMonitoredItem item, int index) -> itemCreationCallback.accept(item, index));
    }

    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn var1, List<MonitoredItemCreateRequest> var2, ItemCreationCallback var3);

    public CompletableFuture<List<StatusCode>> modifyMonitoredItems(TimestampsToReturn var1, List<MonitoredItemModifyRequest> var2);

    public CompletableFuture<List<StatusCode>> deleteMonitoredItems(List<UaMonitoredItem> var1);

    public CompletableFuture<List<StatusCode>> setMonitoringMode(MonitoringMode var1, List<UaMonitoredItem> var2);

    public CompletableFuture<StatusCode> setPublishingMode(boolean var1);

    public void addNotificationListener(NotificationListener var1);

    public void removeNotificationListener(NotificationListener var1);

    public static interface NotificationListener {
        default public void onDataChangeNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<DataValue> dataValues, DateTime publishTime) {
        }

        default public void onEventNotification(UaSubscription subscription, List<UaMonitoredItem> monitoredItems, List<Variant[]> eventFields, DateTime publishTime) {
        }

        default public void onKeepAliveNotification(UaSubscription subscription, DateTime publishTime) {
        }

        default public void onStatusChangedNotification(UaSubscription subscription, StatusCode status) {
        }
    }

    public static interface ItemCreationCallback {
        public void onItemCreated(SerializationContext var1, UaMonitoredItem var2, int var3);
    }
}

