/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import org.eclipse.milo.opcua.binaryschema.parser.BsdParser;
import org.eclipse.milo.opcua.binaryschema.parser.DictionaryDescription;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaBinaryDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeDictionaryReader {
    private static final int DEFAULT_FRAGMENT_SIZE = 8192;
    private static final int PARTITION_SIZE = 64;
    private static final QualifiedName QN_DEFAULT_BINARY = new QualifiedName(0, "Default Binary");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UaStackClient stackClient;
    private final OpcUaSession session;
    private final BsdParser bsdParser;

    public DataTypeDictionaryReader(UaStackClient stackClient, OpcUaSession session, BsdParser bsdParser) {
        this.stackClient = stackClient;
        this.session = session;
        this.bsdParser = bsdParser;
    }

    public CompletableFuture<List<DataTypeDictionary<?>>> readDataTypeDictionaries() {
        CompletableFuture<List<ReferenceDescription>> browseFuture = this.browseNode(new BrowseDescription(Identifiers.OPCBinarySchema_TypeSystem, BrowseDirection.Forward, Identifiers.HasComponent, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Variable.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
        CompletionStage dictionaryNodeIds = browseFuture.thenApply(references -> references.stream().filter(r -> r.getNodeId().getNamespaceIndex().intValue() != 0).filter(r -> r.getTypeDefinition().equals((Object)Identifiers.DataTypeDictionaryType.expanded())).flatMap(r -> StreamUtil.opt2stream((Optional)r.getNodeId().local())));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)dictionaryNodeIds).thenApply(nodeIds -> nodeIds.map(this::readDataTypeDictionary).collect(Collectors.toList()))).thenCompose(FutureUtils::sequence)).thenApply(list -> list.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private CompletableFuture<DataTypeDictionary<?>> readDataTypeDictionary(NodeId nodeId) {
        this.logger.debug("Reading DataTypeDictionary nodeId={}", (Object)nodeId);
        return ((CompletableFuture)this.readDataTypeDictionaryBytes(nodeId, 8192).thenCompose(bs -> this.createDataTypeDictionary(nodeId, (ByteString)bs))).exceptionally(ex -> {
            this.logger.debug("Failed to create DataTypeDictionary: {}", (Object)ex.getMessage(), ex);
            return null;
        });
    }

    CompletableFuture<ByteString> readDataTypeDictionaryBytes(NodeId nodeId, int fragmentSize) {
        CompositeByteBuf fragmentBuffer = Unpooled.compositeBuffer();
        CompletableFuture<ByteBuf> future = this.readFragments(nodeId, fragmentBuffer, fragmentSize, 0);
        return future.thenApply(buffer -> {
            int length = buffer.readableBytes();
            for (int i = buffer.writerIndex() - 1; i >= 0; --i) {
                boolean empty;
                byte lastByte = buffer.getByte(i);
                boolean bl = empty = lastByte == 0 || Character.isWhitespace(lastByte) || Character.isSpaceChar(lastByte);
                if (!empty) break;
                --length;
            }
            byte[] bs = new byte[length];
            buffer.readBytes(bs, 0, length);
            if (this.logger.isDebugEnabled()) {
                String xmlString = new String(bs);
                this.logger.debug("Dictionary XML: {}", (Object)xmlString);
            }
            return ByteString.of((byte[])bs);
        });
    }

    private CompletableFuture<ByteBuf> readFragments(NodeId nodeId, CompositeByteBuf fragmentBuffer, int fragmentSize, int index) {
        Preconditions.checkArgument((fragmentSize > 0 ? 1 : 0) != 0, (Object)("fragmentSize=" + fragmentSize));
        String indexRange = fragmentSize <= 1 ? String.valueOf(index) : String.format("%d:%d", index, index + fragmentSize - 1);
        CompletableFuture<DataValue> valueFuture = this.readNode(new ReadValueId(nodeId, AttributeId.Value.uid(), indexRange, QualifiedName.NULL_VALUE));
        return valueFuture.thenComposeAsync(value -> {
            StatusCode statusCode = value.getStatusCode();
            if (statusCode == null || statusCode.isGood()) {
                ByteString fragmentBytes = (ByteString)value.getValue().getValue();
                if (fragmentBytes != null) {
                    int bytesRead = fragmentBytes.length();
                    if (bytesRead > 0) {
                        fragmentBuffer.addComponent(Unpooled.wrappedBuffer((byte[])fragmentBytes.bytesOrEmpty()));
                        fragmentBuffer.writerIndex(fragmentBuffer.writerIndex() + bytesRead);
                    }
                    if (bytesRead < fragmentSize) {
                        return CompletableFuture.completedFuture(fragmentBuffer);
                    }
                    if (bytesRead > fragmentSize) {
                        return CompletableFuture.completedFuture(fragmentBuffer);
                    }
                    return this.readFragments(nodeId, fragmentBuffer, fragmentSize, index + bytesRead);
                }
                this.logger.warn("Read a null type dictionary fragment at indexRange=\"%s\"", (Object)indexRange);
                return CompletableFuture.completedFuture(fragmentBuffer);
            }
            if (statusCode.getValue() != 2151088128L) {
                this.logger.warn("Reading type dictionary fragments expected to terminate with Bad_IndexRangeNoData but got {}", (Object)statusCode);
            }
            return CompletableFuture.completedFuture(fragmentBuffer);
        });
    }

    private CompletableFuture<DataTypeDictionary<?>> createDataTypeDictionary(NodeId dictionaryNodeId, ByteString bs) {
        ByteArrayInputStream is = new ByteArrayInputStream(bs.bytesOrEmpty());
        try {
            DictionaryDescription dictionaryDescription = this.bsdParser.parse((InputStream)is);
            String namespaceUri = dictionaryDescription.getNamespaceUri();
            OpcUaBinaryDataTypeDictionary dictionary = new OpcUaBinaryDataTypeDictionary(namespaceUri);
            dictionaryDescription.getEnumCodecs().forEach(cd -> dictionary.registerEnumCodec(cd.getCodec(), cd.getDescription()));
            List structCodecs = dictionaryDescription.getStructCodecs();
            CompletableFuture<List<NodeId>> descriptionNodeIds = this.browseDataTypeDescriptionNodeIds(dictionaryNodeId);
            CompletionStage descriptionValues = descriptionNodeIds.thenCompose(this::readDataTypeDescriptionValues);
            if (this.logger.isTraceEnabled()) {
                try {
                    List<NodeId> ids = descriptionNodeIds.get();
                    List values = (List)((CompletableFuture)descriptionValues).get();
                    if (ids.size() != values.size()) {
                        throw new IllegalStateException("size mismatch");
                    }
                    for (int i = 0; i < ids.size(); ++i) {
                        NodeId id = ids.get(i);
                        String value = (String)values.get(i);
                        this.logger.trace("description NodeId={} value={}", (Object)id, (Object)value);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error reading description NodeIds", (Throwable)e);
                }
            }
            CompletionStage encodingIdsFuture = descriptionNodeIds.thenCompose(this::browseDataTypeEncodingNodeIds);
            return ((CompletableFuture)encodingIdsFuture).thenCompose(arg_0 -> this.lambda$createDataTypeDictionary$14((CompletableFuture)descriptionValues, structCodecs, dictionary, arg_0));
        }
        catch (JAXBException e) {
            return FutureUtils.failedFuture((Throwable)e);
        }
    }

    private CompletableFuture<List<NodeId>> browseDataTypeDescriptionNodeIds(NodeId dictionaryNodeId) {
        CompletableFuture<List<ReferenceDescription>> browseResult = this.browseNode(new BrowseDescription(dictionaryNodeId, BrowseDirection.Forward, Identifiers.HasComponent, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Variable.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
        return browseResult.thenApply(references -> references.stream().filter(r -> Identifiers.DataTypeDescriptionType.expanded().equals((Object)r.getTypeDefinition())).flatMap(r -> StreamUtil.opt2stream((Optional)r.getNodeId().local())).collect(Collectors.toList()));
    }

    private CompletableFuture<List<String>> readDataTypeDescriptionValues(List<NodeId> nodeIds) {
        CompletionStage maxNodesPerRead = this.readNode(new ReadValueId(Identifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).thenApply(dv -> (UInteger)dv.getValue().getValue());
        CompletionStage getPartitionSize = ((CompletableFuture)((CompletableFuture)maxNodesPerRead).thenApply(m -> Math.max(1, Ints.saturatedCast((long)m.longValue())))).exceptionally(ex -> 64);
        return ((CompletableFuture)getPartitionSize).thenCompose(partitionSize -> {
            List partitions = Lists.partition((List)nodeIds, (int)partitionSize);
            CompletableFuture sequence = FutureUtils.sequence(partitions.stream().map(list -> {
                List<ReadValueId> readValueIds = list.stream().map(nodeId -> new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
                return this.readNodes(readValueIds);
            }));
            return sequence.thenApply(values -> values.stream().flatMap(Collection::stream).map(v -> (String)v.getValue().getValue()).collect(Collectors.toList()));
        });
    }

    private CompletableFuture<List<NodeId>> browseDataTypeEncodingNodeIds(List<NodeId> descriptionNodeIds) {
        Stream<CompletableFuture> futures = descriptionNodeIds.stream().map(nodeId -> {
            CompletableFuture<List<ReferenceDescription>> browse = this.browseNode(new BrowseDescription(nodeId, BrowseDirection.Inverse, Identifiers.HasDescription, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.Object.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
            return browse.thenApply(references -> {
                Optional<ReferenceDescription> ref = references.stream().filter(r -> QN_DEFAULT_BINARY.equals((Object)r.getBrowseName()) && Identifiers.DataTypeEncodingType.expanded().equals((Object)r.getTypeDefinition())).findFirst();
                return ref.map(r -> r.getNodeId().local().orElse(NodeId.NULL_VALUE)).orElse(NodeId.NULL_VALUE);
            });
        });
        return FutureUtils.sequence(futures);
    }

    private CompletableFuture<List<NodeId>> browseDataTypeIds(List<NodeId> dataTypeEncodingIds) {
        Stream<CompletableFuture> futures = dataTypeEncodingIds.stream().map(nodeId -> {
            CompletableFuture<List<ReferenceDescription>> browse = this.browseNode(new BrowseDescription(nodeId, BrowseDirection.Inverse, Identifiers.HasEncoding, Boolean.valueOf(false), Unsigned.uint((int)NodeClass.DataType.getValue()), Unsigned.uint((int)BrowseResultMask.All.getValue())));
            return browse.thenApply(references -> {
                Optional ref = references.stream().findFirst();
                return ref.map(r -> r.getNodeId().local().orElse(NodeId.NULL_VALUE)).orElse(NodeId.NULL_VALUE);
            });
        });
        return FutureUtils.sequence(futures);
    }

    private CompletableFuture<List<ReferenceDescription>> browseNode(BrowseDescription browseDescription) {
        RequestHeader requestHeader = this.stackClient.newRequestHeader(this.session.getAuthenticationToken(), Unsigned.uint((int)60000));
        BrowseRequest browseRequest = new BrowseRequest(requestHeader, new ViewDescription(NodeId.NULL_VALUE, DateTime.MIN_VALUE, Unsigned.uint((int)0)), Unsigned.uint((int)0), new BrowseDescription[]{browseDescription});
        return ((CompletableFuture)((CompletableFuture)this.stackClient.sendRequest((UaRequestMessage)browseRequest).thenApply(BrowseResponse.class::cast)).thenApply(r -> Objects.requireNonNull(r.getResults())[0])).thenCompose(result -> {
            List<ReferenceDescription> references = Collections.synchronizedList(new ArrayList());
            return this.maybeBrowseNext((BrowseResult)result, references);
        });
    }

    private CompletionStage<List<ReferenceDescription>> maybeBrowseNext(BrowseResult result, List<ReferenceDescription> references) {
        if (result.getStatusCode().isGood()) {
            ByteString continuationPoint;
            ReferenceDescription[] rds = result.getReferences();
            if (rds != null) {
                Collections.addAll(references, rds);
            }
            if ((continuationPoint = result.getContinuationPoint()).isNotNull()) {
                this.logger.debug("Continuation point was non-null; calling BrowseNext");
                return this.browseNextAsync(continuationPoint, references);
            }
            this.logger.debug("Browse finished with {} references", (Object)references.size());
            return CompletableFuture.completedFuture(references);
        }
        return CompletableFuture.completedFuture(references);
    }

    private CompletableFuture<List<ReferenceDescription>> browseNextAsync(ByteString continuationPoint, List<ReferenceDescription> references) {
        RequestHeader requestHeader = this.stackClient.newRequestHeader(this.session.getAuthenticationToken(), Unsigned.uint((int)60000));
        BrowseNextRequest request = new BrowseNextRequest(requestHeader, Boolean.valueOf(false), new ByteString[]{continuationPoint});
        return ((CompletableFuture)this.stackClient.sendRequest((UaRequestMessage)request).thenApply(BrowseNextResponse.class::cast)).thenCompose(response -> {
            BrowseResult result = (BrowseResult)ConversionUtil.l((Object[])response.getResults()).get(0);
            return this.maybeBrowseNext(result, references);
        });
    }

    private CompletableFuture<DataValue> readNode(ReadValueId readValueId) {
        return this.readNodes(Lists.newArrayList((Object[])new ReadValueId[]{readValueId})).thenApply(values -> (DataValue)values.get(0));
    }

    private CompletableFuture<List<DataValue>> readNodes(List<ReadValueId> readValueIds) {
        RequestHeader requestHeader = this.stackClient.newRequestHeader(this.session.getAuthenticationToken(), Unsigned.uint((int)60000));
        ReadRequest readRequest = new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, readValueIds.toArray(new ReadValueId[0]));
        return ((CompletableFuture)this.stackClient.sendRequest((UaRequestMessage)readRequest).thenApply(ReadResponse.class::cast)).thenApply(r -> ConversionUtil.l((Object[])r.getResults()));
    }

    private /* synthetic */ CompletionStage lambda$createDataTypeDictionary$14(CompletableFuture descriptionValues, List structCodecs, OpcUaBinaryDataTypeDictionary dictionary, List encodingIds) {
        return this.browseDataTypeIds(encodingIds).thenCompose(dataTypeIds -> descriptionValues.thenApply(descriptions -> {
            HashMap encodingIdMap = new HashMap();
            HashMap dataTypeIdMap = new HashMap();
            Iterator descriptionIter = descriptions.iterator();
            Iterator encodingIdIter = encodingIds.iterator();
            Iterator dataTypeIdIter = dataTypeIds.iterator();
            while (descriptionIter.hasNext() && encodingIdIter.hasNext() && dataTypeIdIter.hasNext()) {
                String description = (String)descriptionIter.next();
                encodingIdMap.put(description, encodingIdIter.next());
                dataTypeIdMap.put(description, dataTypeIdIter.next());
            }
            structCodecs.forEach(cd -> {
                String description = cd.getDescription();
                NodeId encodingId = (NodeId)encodingIdMap.get(description);
                NodeId dataTypeId = (NodeId)dataTypeIdMap.get(description);
                if (encodingId == null || encodingId.isNull()) {
                    this.logger.warn("encodingId is null for description={}", (Object)description);
                } else if (dataTypeId == null || dataTypeId.isNull()) {
                    this.logger.warn("dataTypeId is null for description={}", (Object)description);
                } else {
                    dictionary.registerStructCodec(cd.getCodec(), description, dataTypeId, encodingId);
                    this.logger.debug("Registered codec description={} dataTypeId={} encodingId={}", new Object[]{description, dataTypeId, encodingId});
                }
            });
            return dictionary;
        }));
    }
}

