/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIManagedProviderTest
extends Arquillian {
    private static final String STUB_URI = "http://localhost:9080/stub";
    @Inject
    @RestClient
    private SimpleGetApi configClient;
    @Inject
    @RestClient
    private MyClientWithAnnotations annotationClient;

    @Deployment
    public static WebArchive createDeployment() {
        String uriProp = SimpleGetApi.class.getName() + "/mp-rest/uri=http://localhost:9080/stub";
        String providerProp = SimpleGetApi.class.getName() + "/mp-rest/providers=" + MyFilter.class.getName();
        String simpleName = CDIManagedProviderTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApi.class})).addAsManifestResource((Asset)new StringAsset(String.format(uriProp + "%n" + providerProp, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testCDIProviderSpecifiedInMPConfig() throws Exception {
        Response r = this.configClient.executeGet();
        Assert.assertEquals((int)r.getStatus(), (int)200);
    }

    @Test
    public void testCDIProviderSpecifiedViaAnnotation() throws Exception {
        Response r = this.annotationClient.executeGet();
        Assert.assertEquals((int)r.getStatus(), (int)200);
    }

    @Test
    public void testCDIProviderSpecifiedViaRestClientBuilder() throws Exception {
        MyProgrammaticClient client = (MyProgrammaticClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(URI.create(STUB_URI)).register(MyFilter.class)).build(MyProgrammaticClient.class);
        Response r = client.executeGet();
        Assert.assertEquals((int)r.getStatus(), (int)200);
    }

    @Test
    public void testInstanceProviderSpecifiedViaRestClientBuilderDoesNotUseCDIManagedProvider() throws Exception {
        MyProgrammaticClient client = (MyProgrammaticClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(URI.create(STUB_URI)).register((Object)new MyFilter())).build(MyProgrammaticClient.class);
        Response r = client.executeGet();
        Assert.assertEquals((int)r.getStatus(), (int)204);
    }

    @ApplicationScoped
    public static class MyFilter
    implements ClientRequestFilter {
        protected boolean postConstructInvoked;
        @Inject
        protected BeanManager beanManager;

        @PostConstruct
        public void postConstruct() {
            this.postConstructInvoked = true;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.abortWith(Response.status((int)(this.beanManager != null && this.postConstructInvoked ? 200 : 204)).build());
        }
    }

    @RegisterRestClient(baseUri="http://localhost:9080/stub")
    @RegisterProvider(value=MyFilter.class)
    public static interface MyClientWithAnnotations {
        @GET
        public Response executeGet();
    }

    public static interface MyProgrammaticClient {
        @GET
        public Response executeGet();
    }
}

