/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.sse;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.servlets.EventSource;
import org.eclipse.microprofile.rest.client.tck.sse.AbstractSseTest;
import org.testng.log4testng.Logger;

public class MyEventSource
implements EventSource {
    private static final Logger LOG = Logger.getLogger(AbstractSseTest.class);
    private EventSource.Emitter emitter;
    private final Consumer<MyEventSource> consumer;
    private final CountDownLatch closeLatch = new CountDownLatch(1);

    MyEventSource(Consumer<MyEventSource> consumer) {
        this.consumer = consumer;
    }

    public void onOpen(EventSource.Emitter emitter) throws IOException {
        this.emitter = emitter;
        ForkJoinPool.commonPool().submit(() -> this.consumer.accept(this));
    }

    public void onClose() {
        this.emitter.close();
        this.emitter = null;
        this.closeLatch.countDown();
    }

    public void emitData(String data) {
        try {
            this.emitter.data(data);
            LOG.debug((Object)("emitted data: " + data));
        }
        catch (IOException e) {
            LOG.debug((Object)"Caught IOException", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void emitComment(String comment) {
        try {
            this.emitter.comment(comment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void emitNamedEvent(String name, String data) {
        try {
            this.emitter.event(name, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.emitter.close();
    }

    public boolean awaitClose(long timeout, TimeUnit unit) {
        try {
            return this.closeLatch.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

