/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.asynctests;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApiAsync;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIInvokeAsyncSimpleGetOperationTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private SimpleGetApiAsync api;
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static WebArchive createDeployment() {
        String propertyName = SimpleGetApiAsync.class.getName() + "/mp-rest/url";
        String value = CDIInvokeAsyncSimpleGetOperationTest.getStringURL();
        String simpleName = CDIInvokeAsyncSimpleGetOperationTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApiAsync.class, WiremockArquillianTest.class})).addAsManifestResource((Asset)new StringAsset(propertyName + "=" + value), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testInvokesGetOperationWithCDIBean() throws Exception {
        String expectedBody = "Hello, MicroProfile!";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withBody("Hello, MicroProfile!")));
        CompletionStage<Response> future = this.api.executeGet();
        Response response = future.toCompletableFuture().get();
        String body = (String)response.readEntity(String.class);
        response.close();
        Assert.assertEquals((String)body, (String)"Hello, MicroProfile!");
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
    }

    @Test
    public void testHasDependentScopedByDefault() {
        Set beans = this.beanManager.getBeans(SimpleGetApiAsync.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), Dependent.class);
    }
}

