/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.cditests.ConfigKeyTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.ConfigKeyClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApiWithConfigKey;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigKeyForMultipleInterfacesTest
extends Arquillian {
    @Inject
    @RestClient
    private ConfigKeyClient client1;
    @Inject
    @RestClient
    private SimpleGetApiWithConfigKey client2;

    @Deployment
    public static WebArchive createDeployment() {
        String uriPropertyName = "myConfigKey/mp-rest/uri";
        String uriValue = "http://localhost:1234/configKeyUri";
        String simpleName = ConfigKeyTest.class.getSimpleName();
        String providerProperty = SimpleGetApiWithConfigKey.class.getName() + "/mp-rest/providers=" + ReturnWithURLRequestFilter.class.getName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{ConfigKeyClient.class, SimpleGetApiWithConfigKey.class, ReturnWithURLRequestFilter.class})).addAsManifestResource((Asset)new StringAsset(String.format(uriPropertyName + "=" + uriValue + "%n" + providerProperty, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testConfigKeyUsedForUri() throws Exception {
        Assert.assertEquals((String)this.client1.get(), (String)"GET http://localhost:1234/configKeyUri/hello");
        Assert.assertEquals((String)((String)this.client2.executeGet().readEntity(String.class)), (String)"GET http://localhost:1234/configKeyUri");
    }
}

