/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.providers;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

@Priority(value=4999)
public class LowerPriorityTestResponseExceptionMapper
implements ResponseExceptionMapper<Throwable> {
    private static boolean handlesCalled = false;
    private static boolean throwableCalled = false;

    public Throwable toThrowable(Response response) {
        throwableCalled = true;
        return new WebApplicationException(LowerPriorityTestResponseExceptionMapper.class.getSimpleName(), response);
    }

    public boolean handles(int status, MultivaluedMap<String, Object> headers) {
        handlesCalled = true;
        return status >= 400;
    }

    public static void reset() {
        handlesCalled = false;
        throwableCalled = false;
    }

    public static boolean isHandlesCalled() {
        return handlesCalled;
    }

    public static boolean isThrowableCalled() {
        return throwableCalled;
    }
}

