/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.WireMock;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.testng.Arquillian;
import org.testng.annotations.BeforeClass;

public abstract class WiremockArquillianTest
extends Arquillian {
    private static Integer port;
    private static String host;
    private static String scheme;
    private static String context;

    private static Integer getPort() {
        if (port == null) {
            WiremockArquillianTest.setupWireMockConnection();
        }
        return port;
    }

    protected static URI getServerURI() {
        try {
            return new URI(WiremockArquillianTest.getStringURL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URI not expected", e);
        }
    }

    protected static URL getServerURL() {
        try {
            return new URL(WiremockArquillianTest.getStringURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL not expected", e);
        }
    }

    protected static String getStringURL() {
        int port = WiremockArquillianTest.getPort();
        return scheme + "://" + host + ":" + port + "" + context;
    }

    @BeforeClass
    public static void setupServer() {
        WiremockArquillianTest.setupWireMockConnection();
        WireMock.configureFor((String)scheme, (String)host, (int)port, (String)context);
        WireMock.reset();
    }

    private static void setupWireMockConnection() {
        host = System.getProperty("wiremock.server.host", "localhost");
        port = Integer.parseInt(System.getProperty("wiremock.server.port", "8765"));
        scheme = System.getProperty("wiremock.server.scheme", "http");
        context = System.getProperty("wiremock.server.context", "/");
    }
}

