/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.net.URI;
import java.util.Map;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.ext.CustomClientHeadersFactory;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientHeadersFactoryClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithAllClientHeadersFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientHeadersFactoryTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ClientHeadersFactoryTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ClientHeadersFactoryClient.class, ReturnWithAllClientHeadersFilter.class});
    }

    private static ClientHeadersFactoryClient client(Class<?> ... providers) {
        try {
            RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri(URI.create("http://localhost:9080/notused"));
            for (Class<?> provider : providers) {
                builder.register(provider);
            }
            return (ClientHeadersFactoryClient)builder.build(ClientHeadersFactoryClient.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Test
    public void testClientHeadersFactoryInvoked() {
        CustomClientHeadersFactory.isIncomingHeadersMapNull = true;
        CustomClientHeadersFactory.isOutgoingHeadersMapNull = true;
        CustomClientHeadersFactory.passedInOutgoingHeaders.clear();
        Map<String, String> headers = ClientHeadersFactoryTest.client(ReturnWithAllClientHeadersFilter.class).delete("argValue");
        Assert.assertFalse((boolean)CustomClientHeadersFactory.isIncomingHeadersMapNull);
        Assert.assertFalse((boolean)CustomClientHeadersFactory.isOutgoingHeadersMapNull);
        Assert.assertEquals((String)((String)CustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"IntfHeader")), (String)"intfValue");
        Assert.assertEquals((String)((String)CustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"MethodHeader")), (String)"methodValue");
        Assert.assertEquals((String)((String)CustomClientHeadersFactory.passedInOutgoingHeaders.getFirst((Object)"ArgHeader")), (String)"argValue");
        Assert.assertEquals((String)headers.get("IntfHeader"), (String)"intfValueModified");
        Assert.assertEquals((String)headers.get("MethodHeader"), (String)"methodValueModified");
        Assert.assertEquals((String)headers.get("ArgHeader"), (String)"argValueModified");
        Assert.assertEquals((String)headers.get("FactoryHeader"), (String)"factoryValue");
    }
}

