/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultExceptionMapperConfigTest
extends WiremockArquillianTest {
    private static final int STATUS = 401;
    private static final String BODY = "body is used by this test";

    @Deployment
    public static Archive<?> createDeployment() {
        StringAsset mpConfig = new StringAsset("microprofile.rest.client.disable.default.mapper=true");
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(DefaultExceptionMapperConfigTest.class.getSimpleName() + ".war"))).addAsWebInfResource((Asset)mpConfig, "classes/META-INF/microprofile-config.properties")).addClasses(new Class[]{SimpleGetApi.class, WiremockArquillianTest.class});
    }

    @Test
    public void testNoExceptionThrownWhenDisabledDuringBuild() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(401).withBody(BODY)));
        SimpleGetApi simpleGetApi = (SimpleGetApi)RestClientBuilder.newBuilder().baseUri(DefaultExceptionMapperConfigTest.getServerURI()).build(SimpleGetApi.class);
        try {
            Response response = simpleGetApi.executeGet();
            Assert.assertEquals((int)response.getStatus(), (int)401);
        }
        catch (Exception w) {
            Assert.fail((String)"No exception should be thrown", (Throwable)w);
        }
    }
}

