/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelConstructionTest {
    @Test
    public void componentsTest() {
        Components c = this.processConstructible(Components.class);
        String callbackKey = "myCallback";
        Callback callbackValue = this.createConstructibleInstance(Callback.class);
        this.checkSameObject(c, c.addCallback("myCallback", callbackValue));
        this.checkMapEntry(c.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)c.getCallbacks().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeCallback("myCallback");
        Assert.assertEquals((int)c.getCallbacks().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getCallbacks(), (arg_0, arg_1) -> ((Components)c).addCallback(arg_0, arg_1), "someCallback", callbackValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(c, c.addExample("myExample", exampleValue));
        this.checkMapEntry(c.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)c.getExamples().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeExample("myExample");
        Assert.assertEquals((int)c.getExamples().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getExamples(), (arg_0, arg_1) -> ((Components)c).addExample(arg_0, arg_1), "someExample", exampleValue);
        String headerKey = "myHeader";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(c, c.addHeader("myHeader", headerValue));
        this.checkMapEntry(c.getHeaders(), "myHeader", headerValue);
        Assert.assertEquals((int)c.getHeaders().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeHeader("myHeader");
        Assert.assertEquals((int)c.getHeaders().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getHeaders(), (arg_0, arg_1) -> ((Components)c).addHeader(arg_0, arg_1), "some-header", headerValue);
        String linkKey = "myLink";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(c, c.addLink("myLink", linkValue));
        this.checkMapEntry(c.getLinks(), "myLink", linkValue);
        Assert.assertEquals((int)c.getLinks().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeLink("myLink");
        Assert.assertEquals((int)c.getLinks().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getLinks(), (arg_0, arg_1) -> ((Components)c).addLink(arg_0, arg_1), "someLink", linkValue);
        String parameterKey = "myParameter";
        Parameter parameterValue = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(c, c.addParameter("myParameter", parameterValue));
        this.checkMapEntry(c.getParameters(), "myParameter", parameterValue);
        Assert.assertEquals((int)c.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeParameter("myParameter");
        Assert.assertEquals((int)c.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getParameters(), (arg_0, arg_1) -> ((Components)c).addParameter(arg_0, arg_1), "someParameter", parameterValue);
        String requestBodyKey = "myRequestBody";
        RequestBody requestBodyValue = this.createConstructibleInstance(RequestBody.class);
        this.checkSameObject(c, c.addRequestBody("myRequestBody", requestBodyValue));
        this.checkMapEntry(c.getRequestBodies(), "myRequestBody", requestBodyValue);
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeRequestBody("myRequestBody");
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getRequestBodies(), (arg_0, arg_1) -> ((Components)c).addRequestBody(arg_0, arg_1), "someRequestBody", requestBodyValue);
        String responseKey = "myResponse";
        APIResponse responseValue = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(c, c.addResponse("myResponse", responseValue));
        this.checkMapEntry(c.getResponses(), "myResponse", responseValue);
        Assert.assertEquals((int)c.getResponses().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeResponse("myResponse");
        Assert.assertEquals((int)c.getResponses().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getResponses(), (arg_0, arg_1) -> ((Components)c).addResponse(arg_0, arg_1), "someResponse", responseValue);
        String schemaKey = "mySchema";
        Schema schemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(c, c.addSchema("mySchema", schemaValue));
        this.checkMapEntry(c.getSchemas(), "mySchema", schemaValue);
        Assert.assertEquals((int)c.getSchemas().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeSchema("mySchema");
        Assert.assertEquals((int)c.getSchemas().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getSchemas(), (arg_0, arg_1) -> ((Components)c).addSchema(arg_0, arg_1), "someSchema", schemaValue);
        String securitySchemeKey = "mySecurityScheme";
        SecurityScheme securitySchemeValue = this.createConstructibleInstance(SecurityScheme.class);
        this.checkSameObject(c, c.addSecurityScheme("mySecurityScheme", securitySchemeValue));
        this.checkMapEntry(c.getSecuritySchemes(), "mySecurityScheme", securitySchemeValue);
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeSecurityScheme("mySecurityScheme");
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getSecuritySchemes(), (arg_0, arg_1) -> ((Components)c).addSecurityScheme(arg_0, arg_1), "someSecurityScheme", securitySchemeValue);
    }

    @Test
    public void externalDocumentationTest() {
        this.processConstructible(ExternalDocumentation.class);
    }

    @Test
    public void openAPITest() {
        OpenAPI o = this.processConstructible(OpenAPI.class);
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        sr.addScheme("BasicAuth");
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeSecurityRequirement(sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)0, (String)"The list is expected to be empty.");
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeServer(s);
        Assert.assertEquals((int)o.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        Tag t = this.createConstructibleInstance(Tag.class);
        this.checkSameObject(o, o.addTag(t));
        this.checkListEntry(o.getTags(), t);
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeTag(t);
        Assert.assertEquals((int)o.getTags().size(), (int)0, (String)"The list is expected to be empty.");
    }

    @Test
    public void operationTest() {
        Operation o = this.processConstructible(Operation.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(o, o.addParameter(p));
        this.checkListEntry(o.getParameters(), p);
        Assert.assertEquals((int)o.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeParameter(p);
        Assert.assertEquals((int)o.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        sr.addScheme("OAuth2", Arrays.asList("read", "write"));
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeSecurityRequirement(sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)0, (String)"The list is expected to be empty.");
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeServer(s);
        Assert.assertEquals((int)o.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        String tag = new String("myTag");
        this.checkSameObject(o, o.addTag(tag));
        this.checkListEntry(o.getTags(), tag);
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeTag(tag);
        Assert.assertEquals((int)o.getTags().size(), (int)0, (String)"The list is expected to be empty.");
        String callbackKey = "myCallback";
        Callback callbackValue = this.createConstructibleInstance(Callback.class);
        this.checkSameObject(o, o.addCallback("myCallback", callbackValue));
        this.checkMapEntry(o.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)o.getCallbacks().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeCallback("myCallback");
        Assert.assertEquals((int)o.getCallbacks().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Operation)o).getCallbacks(), (arg_0, arg_1) -> ((Operation)o).addCallback(arg_0, arg_1), "someCallback", callbackValue);
    }

    @Test
    public void pathItemTest() {
        PathItem pi = this.processConstructible(PathItem.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(pi, pi.addParameter(p));
        this.checkListEntry(pi.getParameters(), p);
        Assert.assertEquals((int)pi.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        pi.removeParameter(p);
        Assert.assertEquals((int)pi.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(pi, pi.addServer(s));
        this.checkListEntry(pi.getServers(), s);
        Assert.assertEquals((int)pi.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        pi.removeServer(s);
        Assert.assertEquals((int)pi.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        Operation o1 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.GET(o1));
        this.checkSameObject(o1, pi.getGET());
        Operation o2 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.PUT(o2));
        this.checkSameObject(o2, pi.getPUT());
        Operation o3 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.POST(o3));
        this.checkSameObject(o3, pi.getPOST());
        Operation o4 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.DELETE(o4));
        this.checkSameObject(o4, pi.getDELETE());
        Operation o5 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.OPTIONS(o5));
        this.checkSameObject(o5, pi.getOPTIONS());
        Operation o6 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.HEAD(o6));
        this.checkSameObject(o6, pi.getHEAD());
        Operation o7 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.PATCH(o7));
        this.checkSameObject(o7, pi.getPATCH());
        Operation o8 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.TRACE(o8));
        this.checkSameObject(o8, pi.getTRACE());
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.GET, o1);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.PUT, o2);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.POST, o3);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.DELETE, o4);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.OPTIONS, o5);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.HEAD, o6);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.PATCH, o7);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.TRACE, o8);
    }

    @Test
    public void pathsTest() {
        Paths p = this.processConstructible(Paths.class);
        String pathItemKey = "/myPathItem";
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem"), (String)"/myPathItem is absent in the map");
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(p, p.addPathItem("/myPathItem", pathItemValue));
        Assert.assertTrue((boolean)p.hasPathItem("/myPathItem"), (String)"/myPathItem is present in the map");
        Assert.assertSame((Object)p.getPathItem("/myPathItem"), (Object)pathItemValue, (String)"The value associated with the key: /myPathItem is expected to be the same one that was added.");
        this.checkMapEntry((Map)p, (Object)"/myPathItem", (Object)pathItemValue);
        this.checkMapEntry(p.getPathItems(), "/myPathItem", pathItemValue);
        String pathItemKey2 = "/myPathItem2";
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem2 is absent in the map");
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        Assert.assertNull((Object)p.put("/myPathItem2", pathItemValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem2 is present in the map");
        Assert.assertSame((Object)p.getPathItem("/myPathItem2"), (Object)pathItemValue2, (String)"The value associated with the key: /myPathItem2 is expected to be the same one that was added.");
        this.checkMapEntry((Map)p, (Object)"/myPathItem2", (Object)pathItemValue2);
        this.checkMapEntry(p.getPathItems(), "/myPathItem2", pathItemValue2);
        Assert.assertEquals((int)p.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)p.getPathItems().size(), (int)2, (String)"The map is expected to contain two entries.");
        p.removePathItem("/myPathItem");
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem"), (String)"/myPathItem is absent in the map");
        Assert.assertEquals((int)p.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)p.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        p.remove((Object)"/myPathItem2");
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem is absent in the map");
        Assert.assertEquals((int)p.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)p.getPathItems().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        PathItem otherValue = this.createConstructibleInstance(PathItem.class);
        this.checkMapImmutable(p, Paths::getPathItems, "/otherPathItem", otherValue);
        this.checkNullValueInAdd(() -> ((Paths)p).getPathItems(), (arg_0, arg_1) -> ((Paths)p).addPathItem(arg_0, arg_1), "/other", otherValue);
    }

    @Test
    public void callbackTest() {
        Callback c = this.processConstructible(Callback.class);
        String pathItemKey = "myPathItem";
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem"), (String)"myPathItem is absent in the map");
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(c, c.addPathItem("myPathItem", pathItemValue));
        Assert.assertTrue((boolean)c.hasPathItem("myPathItem"), (String)"myPathItem is present in the map");
        Assert.assertSame((Object)c.getPathItem("myPathItem"), (Object)pathItemValue, (String)"The value associated with the key: myPathItem is expected to be the same one that was added.");
        this.checkMapEntry((Map)c, (Object)"myPathItem", (Object)pathItemValue);
        this.checkMapEntry(c.getPathItems(), "myPathItem", pathItemValue);
        String pathItemKey2 = "myPathItem2";
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem2 is absent in the map");
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        Assert.assertNull((Object)c.put("myPathItem2", pathItemValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem2 is present in the map");
        Assert.assertSame((Object)c.getPathItem("myPathItem2"), (Object)pathItemValue2, (String)"The value associated with the key: myPathItem2 is expected to be the same one that was added.");
        this.checkMapEntry((Map)c, (Object)"myPathItem2", (Object)pathItemValue2);
        this.checkMapEntry(c.getPathItems(), "myPathItem2", pathItemValue2);
        Assert.assertEquals((int)c.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)c.getPathItems().size(), (int)2, (String)"The map is expected to contain two entries.");
        c.removePathItem("myPathItem");
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem"), (String)"myPathItem is absent in the map");
        Assert.assertEquals((int)c.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)c.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.remove((Object)"myPathItem2");
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem is absent in the map");
        Assert.assertEquals((int)c.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)c.getPathItems().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        PathItem otherValue = this.createConstructibleInstance(PathItem.class);
        this.checkMapImmutable(c, Callback::getPathItems, "otherPathItem", otherValue);
        this.checkNullValueInAdd(() -> ((Callback)c).getPathItems(), (arg_0, arg_1) -> ((Callback)c).addPathItem(arg_0, arg_1), "other", otherValue);
    }

    @Test
    public void exampleTest() {
        this.processConstructible(Example.class);
    }

    @Test
    public void headerTest() {
        Header h = this.processConstructible(Header.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(h, h.addExample("myExample", exampleValue));
        this.checkMapEntry(h.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)h.getExamples().size(), (int)1, (String)"The list is expected to contain one entry.");
        h.removeExample("myExample");
        Assert.assertEquals((int)h.getExamples().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Header)h).getExamples(), (arg_0, arg_1) -> ((Header)h).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void contactTest() {
        this.processConstructible(Contact.class);
    }

    @Test
    public void infoTest() {
        this.processConstructible(Info.class);
    }

    @Test
    public void licenseTest() {
        this.processConstructible(License.class);
    }

    @Test
    public void linkTest() {
        Link l = this.processConstructible(Link.class);
        String parameterKey = "myParameter";
        String parameterValue = "$request.parameter.id";
        this.checkSameObject(l, l.addParameter("myParameter", (Object)"$request.parameter.id"));
        this.checkMapEntry(l.getParameters(), "myParameter", "$request.parameter.id");
        Assert.assertEquals((int)l.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        l.removeParameter("myParameter");
        Assert.assertEquals((int)l.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Link)l).getParameters(), (arg_0, arg_1) -> ((Link)l).addParameter(arg_0, arg_1), "otherParameter", "$request.parameter.id");
    }

    @Test
    public void contentTest() {
        Content c = this.processConstructible(Content.class);
        String mediaTypeKey = "application/json";
        Assert.assertFalse((boolean)c.hasMediaType("application/json"), (String)"application/json is absent in the map");
        MediaType mediaTypeValue = this.createConstructibleInstance(MediaType.class);
        this.checkSameObject(c, c.addMediaType("application/json", mediaTypeValue));
        Assert.assertTrue((boolean)c.hasMediaType("application/json"), (String)"application/json is present in the map");
        Assert.assertSame((Object)c.getMediaType("application/json"), (Object)mediaTypeValue, (String)"The value associated with the key: application/json is expected to be the same one that was added.");
        this.checkMapEntry((Map)c, (Object)"application/json", (Object)mediaTypeValue);
        this.checkMapEntry(c.getMediaTypes(), "application/json", mediaTypeValue);
        String mediaTypeKey2 = "*/*";
        Assert.assertFalse((boolean)c.hasMediaType("*/*"), (String)"*/* is absent in the map");
        MediaType mediaTypeValue2 = this.createConstructibleInstance(MediaType.class);
        Assert.assertNull((Object)c.put("*/*", mediaTypeValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)c.hasMediaType("*/*"), (String)"*/* is present in the map");
        Assert.assertSame((Object)c.getMediaType("*/*"), (Object)mediaTypeValue2, (String)"The value associated with the key: */* is expected to be the same one that was added.");
        this.checkMapEntry((Map)c, (Object)"*/*", (Object)mediaTypeValue2);
        this.checkMapEntry(c.getMediaTypes(), "*/*", mediaTypeValue2);
        Assert.assertEquals((int)c.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)2, (String)"The map is expected to contain two entries.");
        c.removeMediaType("application/json");
        Assert.assertFalse((boolean)c.hasMediaType("application/json"), (String)"application/json is absent in the map");
        Assert.assertEquals((int)c.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.remove((Object)"*/*");
        Assert.assertFalse((boolean)c.hasMediaType("*/*"), (String)"application/json is absent in the map");
        Assert.assertEquals((int)c.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        MediaType otherValue = this.createConstructibleInstance(MediaType.class);
        this.checkMapImmutable(c, Content::getMediaTypes, "application/txt", otherValue);
    }

    @Test
    public void discriminatorTest() {
        Discriminator d = this.processConstructible(Discriminator.class);
        String key = "myKey";
        String value = new String("myValue");
        this.checkSameObject(d, d.addMapping("myKey", value));
        this.checkMapEntry(d.getMapping(), "myKey", value);
        Assert.assertEquals((int)d.getMapping().size(), (int)1, (String)"The list is expected to contain one entry.");
        d.removeMapping("myKey");
        Assert.assertEquals((int)d.getMapping().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Discriminator)d).getMapping(), (arg_0, arg_1) -> ((Discriminator)d).addMapping(arg_0, arg_1), "otherKey", value);
    }

    @Test
    public void encodingTest() {
        Encoding e = this.processConstructible(Encoding.class);
        String headerKey = "myHeaderKey";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(e, e.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(e.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)e.getHeaders().size(), (int)1, (String)"The list is expected to contain one entry.");
        e.removeHeader("myHeaderKey");
        Assert.assertEquals((int)e.getHeaders().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Encoding)e).getHeaders(), (arg_0, arg_1) -> ((Encoding)e).addHeader(arg_0, arg_1), "otherHeaderKey", headerValue);
    }

    @Test
    public void mediaTypeTest() {
        MediaType mt = this.processConstructible(MediaType.class);
        String encodingKey = "myEncoding";
        Encoding encodingValue = this.createConstructibleInstance(Encoding.class);
        this.checkSameObject(mt, mt.addEncoding("myEncoding", encodingValue));
        this.checkMapEntry(mt.getEncoding(), "myEncoding", encodingValue);
        Assert.assertEquals((int)mt.getEncoding().size(), (int)1, (String)"The list is expected to contain one entry.");
        mt.removeEncoding("myEncoding");
        Assert.assertEquals((int)mt.getEncoding().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((MediaType)mt).getEncoding(), (arg_0, arg_1) -> ((MediaType)mt).addEncoding(arg_0, arg_1), "otherEncoding", encodingValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(mt, mt.addExample("myExample", exampleValue));
        this.checkMapEntry(mt.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)mt.getExamples().size(), (int)1, (String)"The list is expected to contain one entry.");
        mt.removeExample("myExample");
        Assert.assertEquals((int)mt.getExamples().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((MediaType)mt).getExamples(), (arg_0, arg_1) -> ((MediaType)mt).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void schemaTest() {
        Schema s = this.processConstructible(Schema.class);
        Schema ap = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.additionalPropertiesSchema(ap));
        this.checkSameObject(ap, s.getAdditionalPropertiesSchema());
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), null, (String)"AdditionalProperties (Boolean type) is expected to be null");
        this.checkSameObject(s, s.additionalPropertiesBoolean(Boolean.TRUE));
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), (Object)Boolean.TRUE, (String)"AdditionalProperties (Boolean type) is expected to be true");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        s.setAdditionalPropertiesBoolean(Boolean.FALSE);
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), (Object)Boolean.FALSE, (String)"AdditionalProperties (Boolean type) is expected to be false");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        s.setAdditionalPropertiesSchema(null);
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), null, (String)"AdditionalProperties (Boolean type) is expected to be null");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        Schema allOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAllOf(allOf));
        this.checkListEntry(s.getAllOf(), allOf);
        Assert.assertEquals((int)s.getAllOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeAllOf(allOf);
        Assert.assertEquals((int)s.getAllOf().size(), (int)0, (String)"The list is expected to be empty.");
        Schema anyOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAnyOf(anyOf));
        this.checkListEntry(s.getAnyOf(), anyOf);
        Assert.assertEquals((int)s.getAnyOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeAnyOf(anyOf);
        Assert.assertEquals((int)s.getAnyOf().size(), (int)0, (String)"The list is expected to be empty.");
        String enumeration = new String("enumValue");
        this.checkSameObject(s, s.addEnumeration((Object)enumeration));
        this.checkListEntry(s.getEnumeration(), enumeration);
        Assert.assertEquals((int)s.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeEnumeration((Object)enumeration);
        Assert.assertEquals((int)s.getEnumeration().size(), (int)0, (String)"The list is expected to be empty.");
        Schema oneOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addOneOf(oneOf));
        this.checkListEntry(s.getOneOf(), oneOf);
        Assert.assertEquals((int)s.getOneOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeOneOf(oneOf);
        Assert.assertEquals((int)s.getOneOf().size(), (int)0, (String)"The list is expected to be empty.");
        String propertySchemaKey = "myPropertySchemaKey";
        Schema propertySchemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addProperty("myPropertySchemaKey", propertySchemaValue));
        this.checkMapEntry(s.getProperties(), "myPropertySchemaKey", propertySchemaValue);
        Assert.assertEquals((int)s.getProperties().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeProperty("myPropertySchemaKey");
        Assert.assertEquals((int)s.getProperties().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Schema)s).getProperties(), (arg_0, arg_1) -> ((Schema)s).addProperty(arg_0, arg_1), "otherProperty", propertySchemaValue);
        String required = new String("required");
        this.checkSameObject(s, s.addRequired(required));
        this.checkListEntry(s.getRequired(), required);
        Assert.assertEquals((int)s.getRequired().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeRequired(required);
        Assert.assertEquals((int)s.getRequired().size(), (int)0, (String)"The list is expected to be empty.");
    }

    @Test
    public void xmlTest() {
        this.processConstructible(XML.class);
    }

    @Test
    public void parameterTest() {
        Parameter p = this.processConstructible(Parameter.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(p, p.addExample("myExample", exampleValue));
        this.checkMapEntry(p.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)p.getExamples().size(), (int)1, (String)"The list is expected to contain one entry.");
        p.removeExample("myExample");
        Assert.assertEquals((int)p.getExamples().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Parameter)p).getExamples(), (arg_0, arg_1) -> ((Parameter)p).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void requestBodyTest() {
        this.processConstructible(RequestBody.class);
    }

    @Test
    public void apiResponseTest() {
        APIResponse response = this.processConstructible(APIResponse.class);
        String headerKey = "myHeaderKey";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(response, response.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(response.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)response.getHeaders().size(), (int)1, (String)"The list is expected to contain one entry.");
        response.removeHeader("myHeaderKey");
        Assert.assertEquals((int)response.getHeaders().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((APIResponse)response).getHeaders(), (arg_0, arg_1) -> ((APIResponse)response).addHeader(arg_0, arg_1), "some-header", headerValue);
        String linkKey = "myLinkKey";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(response, response.addLink("myLinkKey", linkValue));
        this.checkMapEntry(response.getLinks(), "myLinkKey", linkValue);
        Assert.assertEquals((int)response.getLinks().size(), (int)1, (String)"The list is expected to contain one entry.");
        response.removeLink("myLinkKey");
        Assert.assertEquals((int)response.getLinks().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((APIResponse)response).getLinks(), (arg_0, arg_1) -> ((APIResponse)response).addLink(arg_0, arg_1), "someLinkKey", linkValue);
    }

    @Test
    public void apiResponsesTest() {
        APIResponses responses = this.processConstructible(APIResponses.class);
        responses.remove((Object)"default");
        Assert.assertEquals((int)responses.size(), (int)0, (String)"The map is expected to contain two entries.");
        String responseKey = "200";
        Assert.assertFalse((boolean)responses.hasAPIResponse("200"), (String)"200 is absent in the map");
        APIResponse pathItemValue = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(responses, responses.addAPIResponse("200", pathItemValue));
        Assert.assertTrue((boolean)responses.hasAPIResponse("200"), (String)"200 is present in the map");
        Assert.assertSame((Object)responses.getAPIResponse("200"), (Object)pathItemValue, (String)"The value associated with the key: 200 is expected to be the same one that was added.");
        this.checkMapEntry((Map)responses, (Object)"200", (Object)pathItemValue);
        this.checkMapEntry(responses.getAPIResponses(), "200", pathItemValue);
        String responseKey2 = "4XX";
        Assert.assertFalse((boolean)responses.hasAPIResponse("4XX"), (String)"4XX is absent in the map");
        APIResponse pathItemValue2 = this.createConstructibleInstance(APIResponse.class);
        Assert.assertNull((Object)responses.put("4XX", pathItemValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)responses.hasAPIResponse("4XX"), (String)"4XX is present in the map");
        Assert.assertSame((Object)responses.getAPIResponse("4XX"), (Object)pathItemValue2, (String)"The value associated with the key: 4XX is expected to be the same one that was added.");
        this.checkMapEntry((Map)responses, (Object)"4XX", (Object)pathItemValue2);
        this.checkMapEntry(responses.getAPIResponses(), "4XX", pathItemValue2);
        Assert.assertEquals((int)responses.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)2, (String)"The map is expected to contain two entries.");
        responses.removeAPIResponse("200");
        Assert.assertFalse((boolean)responses.hasAPIResponse("200"), (String)"200 is absent in the map");
        Assert.assertEquals((int)responses.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        responses.remove((Object)"4XX");
        Assert.assertFalse((boolean)responses.hasAPIResponse("4XX"), (String)"200 is absent in the map");
        Assert.assertEquals((int)responses.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        APIResponse otherValue = this.createConstructibleInstance(APIResponse.class);
        this.checkMapImmutable(responses, APIResponses::getAPIResponses, "500", otherValue);
        Assert.assertNull((Object)responses.getDefaultValue(), (String)"No default value expected.");
        String responseKey3 = "default";
        APIResponse responseValue3 = this.createConstructibleInstance(APIResponse.class);
        Assert.assertNull((Object)responses.put("default", responseValue3), (String)"No previous mapping expected.");
        this.checkMapEntry((Map)responses, (Object)"default", (Object)responseValue3);
        this.checkSameObject(responseValue3, responses.getDefaultValue());
        Assert.assertEquals((int)responses.size(), (int)1, (String)"The map is expected to contain one entry.");
        responses.setDefaultValue(null);
        Assert.assertNull((Object)responses.get((Object)"default"), (String)"No default value expected.");
        Assert.assertNull((Object)responses.getDefaultValue(), (String)"No default value expected.");
        APIResponse responseValue4 = this.createConstructibleInstance(APIResponse.class);
        responses.setDefaultValue(responseValue4);
        this.checkMapEntry((Map)responses, (Object)"default", (Object)responseValue4);
        this.checkSameObject(responseValue4, responses.getDefaultValue());
        this.checkNullValueInAdd(() -> ((APIResponses)responses).getAPIResponses(), (arg_0, arg_1) -> ((APIResponses)responses).addAPIResponse(arg_0, arg_1), "4XX", otherValue);
    }

    @Test
    public void oAuthFlowTest() {
        this.processConstructible(OAuthFlow.class);
    }

    @Test
    public void oAuthFlowsTest() {
        this.processConstructible(OAuthFlows.class);
    }

    @Test
    public void scopesTest() {
        Scopes s = this.processConstructible(Scopes.class);
        String scopeKey = "myScope";
        Assert.assertFalse((boolean)s.hasScope("myScope"), (String)"myScope is absent in the map");
        String scopeValue = new String("myDescription");
        this.checkSameObject(s, s.addScope("myScope", scopeValue));
        Assert.assertTrue((boolean)s.hasScope("myScope"), (String)"myScope is present in the map");
        Assert.assertSame((Object)s.getScope("myScope"), (Object)scopeValue, (String)"The value associated with the key: myScope is expected to be the same one that was added.");
        this.checkMapEntry((Map)s, (Object)"myScope", (Object)scopeValue);
        this.checkMapEntry(s.getScopes(), "myScope", scopeValue);
        String scopeKey2 = "myScope2";
        Assert.assertFalse((boolean)s.hasScope("myScope2"), (String)"myScope2 is absent in the map");
        String scopeValue2 = new String("myDescription2");
        Assert.assertNull((Object)s.put("myScope2", scopeValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)s.hasScope("myScope2"), (String)"myScope2 is present in the map");
        Assert.assertSame((Object)s.getScope("myScope2"), (Object)scopeValue2, (String)"The value associated with the key: myScope2 is expected to be the same one that was added.");
        this.checkMapEntry((Map)s, (Object)"myScope2", (Object)scopeValue2);
        this.checkMapEntry(s.getScopes(), "myScope2", scopeValue2);
        Assert.assertEquals((int)s.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)s.getScopes().size(), (int)2, (String)"The map is expected to contain two entries.");
        s.removeScope("myScope");
        Assert.assertFalse((boolean)s.hasScope("myScope"), (String)"myScope is absent in the map");
        Assert.assertEquals((int)s.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)s.getScopes().size(), (int)1, (String)"The map is expected to contain one entry.");
        s.remove((Object)"myScope2");
        Assert.assertFalse((boolean)s.hasScope("myScope2"), (String)"myScope is absent in the map");
        Assert.assertEquals((int)s.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)s.getScopes().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        String otherValue = new String("otherDescription");
        this.checkMapImmutable(s, Scopes::getScopes, "otherScope", otherValue);
        String scopeKey3 = "myScope3";
        s.addScope(scopeKey3, null);
        Assert.assertTrue((boolean)s.hasScope(scopeKey3), (String)("Expected " + scopeKey3 + " to be present in the map"));
        Assert.assertNull((Object)s.getScope(scopeKey3), (String)("Expected the value of " + scopeKey3 + " to be null."));
    }

    @Test
    public void securityRequirementTest() {
        SecurityRequirement sr = this.processConstructible(SecurityRequirement.class);
        String schemeKey = "myScheme";
        Assert.assertFalse((boolean)sr.hasScheme("myScheme"), (String)"myScheme is absent in the map");
        ArrayList schemeValue = new ArrayList();
        this.checkSameObject(sr, sr.addScheme("myScheme", schemeValue));
        Assert.assertTrue((boolean)sr.hasScheme("myScheme"), (String)"myScheme is present in the map");
        Assert.assertSame((Object)sr.getScheme("myScheme"), schemeValue, (String)"The value associated with the key: myScheme is expected to be the same one that was added.");
        this.checkMapEntry((Map)sr, (Object)"myScheme", (Object)schemeValue);
        this.checkMapEntry(sr.getSchemes(), "myScheme", schemeValue);
        String schemeKey2 = "myScheme2";
        Assert.assertFalse((boolean)sr.hasScheme("myScheme2"), (String)"myScheme2 is absent in the map");
        ArrayList schemeValue2 = new ArrayList();
        Assert.assertNull((Object)sr.put("myScheme2", schemeValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)sr.hasScheme("myScheme2"), (String)"myScheme2 is present in the map");
        Assert.assertSame((Object)sr.getScheme("myScheme2"), schemeValue2, (String)"The value associated with the key: myScheme2 is expected to be the same one that was added.");
        this.checkMapEntry((Map)sr, (Object)"myScheme2", (Object)schemeValue2);
        this.checkMapEntry(sr.getSchemes(), "myScheme2", schemeValue2);
        Assert.assertEquals((int)sr.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)2, (String)"The map is expected to contain two entries.");
        sr.removeScheme("myScheme");
        Assert.assertFalse((boolean)sr.hasScheme("myScheme"), (String)"myScheme is absent in the map");
        Assert.assertEquals((int)sr.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)1, (String)"The map is expected to contain one entry.");
        sr.remove((Object)"myScheme2");
        Assert.assertFalse((boolean)sr.hasScheme("myScheme2"), (String)"myScheme is absent in the map");
        Assert.assertEquals((int)sr.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        ArrayList otherValue = new ArrayList();
        this.checkMapImmutable(sr, SecurityRequirement::getSchemes, "otherScheme", otherValue);
        String schemeKey3 = "myScheme3";
        sr.addScheme("myScheme3", (String)null);
        Assert.assertTrue((boolean)sr.hasScheme("myScheme3"), (String)"Expected myScheme3 to be present");
        List schemeValue3 = Collections.emptyList();
        Assert.assertEquals((Collection)sr.getScheme("myScheme3"), schemeValue3, (String)"The value associated with the key: myScheme3 is expected to be an empty list.");
        String schemeKey4 = "myScheme3";
        sr.addScheme("myScheme3", (List)null);
        Assert.assertTrue((boolean)sr.hasScheme("myScheme3"), (String)"Expected myScheme3 to be present");
        List schemeValue4 = Collections.emptyList();
        Assert.assertEquals((Collection)sr.getScheme("myScheme3"), schemeValue4, (String)"The value associated with the key: myScheme3 is expected to be an empty list.");
    }

    @Test
    public void securitySchemeTest() {
        this.processConstructible(SecurityScheme.class);
    }

    @Test
    public void serverTest() {
        Server server = this.processConstructible(Server.class);
        ServerVariable sv1 = this.createConstructibleInstance(ServerVariable.class);
        server.setVariables(Collections.singletonMap("var1", sv1));
        ServerVariables variables = server.getVariables();
        Assert.assertEquals((int)variables.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertTrue((boolean)variables.containsKey("var1"), (String)"The map is expected to contain a 'var1' entry.");
        Assert.assertEquals(variables.get("var1"), (Object)sv1, (String)"The value corresponding to the 'var1' is wrong.");
        server.setVariables((Map)null);
        Assert.assertNull((Object)server.getVariables(), (String)"The value is expected to be null.");
    }

    @Test
    public void serverVariableTest() {
        ServerVariable sv = this.processConstructible(ServerVariable.class);
        String enumeration = new String("enumValue");
        this.checkSameObject(sv, sv.addEnumeration(enumeration));
        this.checkListEntry(sv.getEnumeration(), enumeration);
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        sv.removeEnumeration(enumeration);
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)0, (String)"The list is expected to be empty.");
    }

    @Test
    @Deprecated
    public void serverVariablesTest() {
        ServerVariables svs = this.processConstructible(ServerVariables.class);
        String varKey = "myServerVariable";
        Assert.assertFalse((boolean)svs.hasServerVariable("myServerVariable"), (String)"myServerVariable is absent in the map");
        ServerVariable varValue = this.createConstructibleInstance(ServerVariable.class);
        this.checkSameObject(svs, svs.addServerVariable("myServerVariable", varValue));
        Assert.assertTrue((boolean)svs.hasServerVariable("myServerVariable"), (String)"myServerVariable is present in the map");
        Assert.assertSame((Object)svs.getServerVariable("myServerVariable"), (Object)varValue, (String)"The value associated with the key: myServerVariable is expected to be the same one that was added.");
        this.checkMapEntry((Map)svs, (Object)"myServerVariable", (Object)varValue);
        this.checkMapEntry(svs.getServerVariables(), "myServerVariable", varValue);
        String varKey2 = "myServerVariable2";
        Assert.assertFalse((boolean)svs.hasServerVariable("myServerVariable2"), (String)"myServerVariable2 is absent in the map");
        ServerVariable varValue2 = this.createConstructibleInstance(ServerVariable.class);
        Assert.assertNull((Object)svs.put("myServerVariable2", varValue2), (String)"No previous mapping expected.");
        Assert.assertTrue((boolean)svs.hasServerVariable("myServerVariable2"), (String)"myServerVariable2 is present in the map");
        Assert.assertSame((Object)svs.getServerVariable("myServerVariable2"), (Object)varValue2, (String)"The value associated with the key: myServerVariable2 is expected to be the same one that was added.");
        this.checkMapEntry((Map)svs, (Object)"myServerVariable2", (Object)varValue2);
        this.checkMapEntry(svs.getServerVariables(), "myServerVariable2", varValue2);
        Assert.assertEquals((int)svs.size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertEquals((int)svs.getServerVariables().size(), (int)2, (String)"The map is expected to contain two entries.");
        svs.removeServerVariable("myServerVariable");
        Assert.assertFalse((boolean)svs.hasServerVariable("myServerVariable"), (String)"myServerVariable is absent in the map");
        Assert.assertEquals((int)svs.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertEquals((int)svs.getServerVariables().size(), (int)1, (String)"The map is expected to contain one entry.");
        svs.remove((Object)"myServerVariable2");
        Assert.assertFalse((boolean)svs.hasServerVariable("myServerVariable2"), (String)"myServerVariable is absent in the map");
        Assert.assertEquals((int)svs.size(), (int)0, (String)"The map is expected to contain 0 entries.");
        Assert.assertEquals((int)svs.getServerVariables().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        ServerVariable otherValue = this.createConstructibleInstance(ServerVariable.class);
        this.checkMapImmutable(svs, ServerVariables::getServerVariables, "otherServerVariable", otherValue);
        this.checkNullValueInAdd(() -> ((ServerVariables)svs).getServerVariables(), (arg_0, arg_1) -> ((ServerVariables)svs).addServerVariable(arg_0, arg_1), "other", otherValue);
    }

    @Test
    public void tagTest() {
        this.processConstructible(Tag.class);
    }

    private <T extends Constructible> T processConstructible(Class<T> clazz) {
        Object o = this.createConstructibleInstance(clazz);
        if (o instanceof Extensible && Extensible.class.isAssignableFrom(clazz)) {
            this.processExtensible((Extensible)o);
        }
        if (o instanceof Reference && Reference.class.isAssignableFrom(clazz)) {
            this.processReference((Reference)o);
        }
        Map<String, Property> properties = this.collectProperties(clazz);
        properties.values().stream().filter(p -> p.isComplete()).forEach(p -> this.processConstructibleProperty((Constructible)o, (Property)p, clazz));
        return o;
    }

    private <T extends Constructible> T createConstructibleInstance(Class<T> clazz) {
        Constructible o1 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o1, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o1), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Constructible o2 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o2, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o2), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Assert.assertNotSame((Object)o2, (Object)o1, (String)("OASFactory.createObject(" + clazz.getName() + ") is expected to create a new object on each invocation."));
        return (T)o1;
    }

    private void processExtensible(Extensible<?> e) {
        String extensionName1 = "x-" + e.getClass().getName() + "-1";
        Object obj1 = new Object();
        String extensionName2 = "x-" + e.getClass().getName() + "-2";
        Object obj2 = new Object();
        e.addExtension(extensionName1, obj1);
        e.addExtension(extensionName2, obj2);
        Map map = e.getExtensions();
        Assert.assertEquals((int)map.size(), (int)2, (String)"The extensions map is expected to contain two entries.");
        Assert.assertTrue((boolean)map.containsKey(extensionName1), (String)("The extensions map is expected to contain the key: " + extensionName1));
        Assert.assertTrue((boolean)map.containsKey(extensionName2), (String)("The extensions map is expected to contain the key: " + extensionName2));
        Assert.assertSame(map.get(extensionName1), (Object)obj1, (String)("The value associated with the key: " + extensionName1 + " is expected to be the same one that was added."));
        Assert.assertSame(map.get(extensionName2), (Object)obj2, (String)("The value associated with the key: " + extensionName2 + " is expected to be the same one that was added."));
        e.removeExtension(extensionName1);
        Assert.assertEquals((int)e.getExtensions().size(), (int)1, (String)"The extensions map is expected to contain one entry.");
        HashMap newMap = new HashMap();
        e.setExtensions(newMap);
        Map map2 = e.getExtensions();
        Assert.assertEquals((int)map2.size(), (int)0, (String)"The extensions map is expected to contain no entries.");
        Assert.assertEquals((Object)map2, newMap, (String)"The return value of getExtensions() is expected to be the same value that was set.");
        HashMap<String, Integer> newOtherMap = new HashMap<String, Integer>();
        newOtherMap.put("x-test", 42);
        e.setExtensions(newOtherMap);
        Map map3 = e.getExtensions();
        Assert.assertEquals((int)map3.size(), (int)1, (String)"The extensions map is expected to contain one entry.");
        Assert.assertEquals((Object)map3, newOtherMap, (String)"The return value of getExtensions() is expected to be the same value that was set.");
    }

    private void processReference(Reference<?> r) {
        String myRef1 = this.createReference(r, "myRef1");
        r.setRef(myRef1);
        Assert.assertEquals((String)r.getRef(), (String)myRef1, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef2";
            String myRef2 = this.createReference(r, "myRef2");
            r.setRef("myRef2");
            Assert.assertEquals((String)r.getRef(), (String)myRef2, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
        String myRef3 = this.createReference(r, "myRef3");
        Reference self = r.ref(myRef3);
        Assert.assertSame((Object)self, r, (String)"The return value of ref() is expected to return the current instance.");
        Assert.assertEquals((String)r.getRef(), (String)myRef3, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef4";
            String myRef4 = this.createReference(r, "myRef4");
            Reference self2 = r.ref("myRef4");
            Assert.assertSame((Object)self2, r, (String)"The return value of ref() is expected to return the current instance.");
            Assert.assertEquals((String)r.getRef(), (String)myRef4, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
    }

    private void processConstructibleProperty(Constructible o, Property p, Class<?> enclosingInterface) {
        Object value1 = this.getInstanceOf(p.getType(), false);
        p.invokeSetter(o, value1);
        if (!(p.isPrimitive() || p.isCompatible(Map.class) || p.isCompatible(List.class))) {
            Assert.assertSame((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
        } else {
            Assert.assertEquals((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
        }
        if (p.hasBuilder()) {
            Object value2 = this.getInstanceOf(p.getType(), true);
            Object self = p.invokeBuilder(o, value2);
            Assert.assertSame((Object)self, (Object)o, (String)("The return value of the builder method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            if (!(p.isPrimitive() || p.isCompatible(Map.class) || p.isCompatible(List.class))) {
                Assert.assertSame((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            } else {
                Assert.assertEquals((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
            }
        }
    }

    private Object getInstanceOf(Class<?> clazz, boolean alternateEnumValue) {
        if (Constructible.class.isAssignableFrom(clazz)) {
            return this.createConstructibleInstance(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            ?[] enumConstants = clazz.getEnumConstants();
            if (enumConstants != null && enumConstants.length > 0) {
                if (alternateEnumValue && enumConstants.length > 1) {
                    return enumConstants[1];
                }
                return enumConstants[0];
            }
        } else {
            if (clazz == List.class) {
                return new ArrayList();
            }
            if (clazz == Map.class) {
                return new HashMap();
            }
            if (clazz == String.class) {
                return new String("value");
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return new Boolean(true);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return new Byte(1);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return new Short(1);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return new Integer(1);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return new Long(1L);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return new Float(1.0f);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return new Double(1.0);
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                return new Character('a');
            }
            if (clazz == BigInteger.class) {
                return new BigInteger("1");
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal("1.0");
            }
            if (clazz == Object.class) {
                return new String("object");
            }
        }
        return null;
    }

    private String createReference(Reference<?> r, String v) {
        StringBuilder sb = new StringBuilder();
        if (r instanceof APIResponse) {
            sb.append("#/components/responses/");
        } else if (r instanceof Callback) {
            sb.append("#/components/callbacks/");
        } else if (r instanceof Example) {
            sb.append("#/components/examples/");
        } else if (r instanceof Header) {
            sb.append("#/components/headers/");
        } else if (r instanceof Link) {
            sb.append("#/components/links/");
        } else if (r instanceof Parameter) {
            sb.append("#/components/parameters/");
        } else if (r instanceof PathItem) {
            sb.append("http://www.abc.def.ghi/");
        } else if (r instanceof RequestBody) {
            sb.append("#/components/requestBodies/");
        } else if (r instanceof Schema) {
            sb.append("#/components/schemas/");
        } else if (r instanceof SecurityScheme) {
            sb.append("#/components/securitySchemes/");
        }
        sb.append(v);
        return sb.toString();
    }

    private Map<String, Property> collectProperties(Class<?> clazz) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Method[] methods = clazz.getDeclaredMethods();
        Arrays.stream(methods).forEach(m -> {
            Class<?> returnType = m.getReturnType();
            int parameterCount = m.getParameterCount();
            String name = m.getName();
            if (returnType == clazz) {
                if (parameterCount == 1) {
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addBuilder((Method)m);
                    }
                }
            } else if (returnType == Void.TYPE) {
                if (name.startsWith("set") && parameterCount == 1) {
                    name = Introspector.decapitalize(name.substring(3));
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addSetter((Method)m);
                    }
                }
            } else if (name.startsWith("get") && parameterCount == 0) {
                name = Introspector.decapitalize(name.substring(3));
                Class<?> type = returnType;
                Property p = (Property)properties.get(name);
                if (p == null) {
                    p = new Property(name, type);
                    properties.put(name, p);
                }
                if (p.isCompatible(type)) {
                    p.addGetter((Method)m);
                }
            }
        });
        return properties;
    }

    private <K, T> void checkMapEntry(Map<K, T> map, K key, T value) {
        Assert.assertNotNull(map, (String)"The map must not be null.");
        Assert.assertTrue((boolean)map.containsKey(key), (String)("The map is expected to contain the key: " + key));
        Assert.assertSame(map.get(key), value, (String)("The value associated with the key: " + key + " is expected to be the same one that was added."));
    }

    private <O, K, T> void checkMapImmutable(O container, Function<O, Map<K, T>> mapGetter, K key, T otherValue) {
        Map<K, T> map = mapGetter.apply(container);
        Assert.assertNotNull(map, (String)"The map must not be null.");
        Assert.assertFalse((boolean)map.containsKey(key), (String)("The map is expected to not contain the key: " + key));
        int originalSize = map.size();
        try {
            map.put(key, otherValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<K, T> map2 = mapGetter.apply(container);
        Assert.assertNotNull(map2, (String)"The map must not be null.");
        Assert.assertFalse((boolean)map2.containsKey(key), (String)("The map is expected to not contain the key: " + key));
        Assert.assertEquals((int)map2.size(), (int)originalSize, (String)("The map is expected to have a size of " + originalSize));
    }

    private <O, T> void checkNullValueInAdd(Supplier<Map<String, T>> mapGetter, BiFunction<String, T, O> mapAdd, String key, T value) {
        try {
            mapAdd.apply(key, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to not contain the key: " + key));
        mapAdd.apply(key, (String)value);
        Assert.assertTrue((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to contain the key: " + key));
        try {
            mapAdd.apply(key, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to contain the key: " + key));
    }

    private <T> void checkListEntry(List<T> list, T value) {
        Assert.assertNotNull(list, (String)"The list must not be null.");
        Assert.assertTrue((boolean)list.stream().anyMatch(v -> v == value), (String)("The list is expected to contain the value: " + value));
    }

    private <T> void checkSameObject(T expected, T actual) {
        Assert.assertSame(actual, expected, (String)"Expecting same object.");
    }

    static final class Property {
        private final String name;
        private final Class<?> type;
        private Method getter;
        private Method setter;
        private Method builder;

        public Property(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public void addGetter(Method getter) {
            this.getter = getter;
        }

        public void addSetter(Method setter) {
            this.setter = setter;
        }

        public void addBuilder(Method builder) {
            this.builder = builder;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean hasBuilder() {
            return this.builder != null;
        }

        public Object invokeGetter(Object target) {
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of getter method \"" + this.getter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public void invokeSetter(Object target, Object value) {
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of setter method \"" + this.setter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public Object invokeBuilder(Object target, Object value) {
            try {
                return this.builder.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of builder method \"" + this.builder.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public boolean isCompatible(Class<?> type) {
            return this.type == type;
        }

        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        public boolean isComplete() {
            return this.getter != null && this.setter != null;
        }
    }
}

