/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import aQute.bnd.annotation.baseline.BaselineIgnore;
import java.io.OutputStream;

public abstract class Snapshot {
    public abstract long size();

    public abstract double getMax();

    public abstract double getMean();

    public abstract PercentileValue[] percentileValues();

    @BaselineIgnore(value="5.2")
    public HistogramBucket[] bucketValues() {
        return new HistogramBucket[0];
    }

    public abstract void dump(OutputStream var1);

    public static class HistogramBucket {
        private final double bucket;
        private final long count;

        public HistogramBucket(double bucket, long count) {
            this.bucket = bucket;
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public double getBucket() {
            return this.bucket;
        }

        public String toString() {
            return "[Bucket: " + this.bucket + " with count: " + this.count + "]";
        }
    }

    public static class PercentileValue {
        private final double percentile;
        private final double value;

        public PercentileValue(double percentile, double value) {
            this.percentile = percentile;
            this.value = value;
        }

        public double getPercentile() {
            return this.percentile;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return "[Percentile: " + this.percentile * 100.0 + "% with Value: " + this.value + "]";
        }
    }
}

